(function($){
	$.widget("mobile.progressNotes", {
		// These options will be used as defaults
		options: {
			clear: null,
			initSelector: ':jqmData(role="progressNotes")',
			isDraft: false,
			page: '#clinic-event',
			links: {},
			user: {},
			patient: {
				lastName: '',
				firstName: '',
				gender: '',
				ssn: '',
				age: '',
				patientIdentifier: {
					uniqueId: ''
				}
			},
			defaults: {
				clinicalEvent: {
					id : '',
					facilityCode : '',
					clinicalEventState : '',
					encounterEdited: false,
					encounterValid: false,
					patientIdentifier : {
						assigningAuthority : '',
						uniqueId : ''
					},
					providerIdentifier : {
						facilityCode : '',
						staffId : ''
					},
					note: {
						title: {
							ien: '',
							name: '',
							isConsult: false
						},
						consultIen: '',
						body: '',
						signedDate: ''
					},
					encounter: {
						timestamp: '',
						locationId: '',
						locationTitle: '',
						currentAdmission: false,
						serviceCategory: '',
						appointmentType: '',
						providers: [{
							primary: false,
							facilityProvider: {
								providerIen: '',
								facilityCode: '',
								providerName: ''
							},
							selected: false
						}] // is supplied currently logged in provider 
					}
				},
				pass: {
					note: false,
					encounter: false,
					//hasEditedEncounter: false,
					visitType: false,
					providers: false,
					related: false,
					diagnoses: false,
					procedures: false
				},
				childCreated: {
					note: false,
					link: false,
					encounter: false,
					sign: false
				}
			},
			autoSaveTimeout: null,
			autoSavePreviousObject: ""
		},
		open: function(){
			var that = this,
				o = this.options,
				$leftPanel = $('.ui-panel-position-left.ui-panel-open');

			// trigger beforeopen
			that._trigger("beforeOpen", null);

			// for responsive design; maybe change to trigger an event in Portal (so that other side panels can call it)
			if ($leftPanel.length) {
				$('#content-secondary').removeClass('hidden');
				$('#content-primary').removeClass('no-float');
				$leftPanel.panel('close');
				$('#slide-btn').trigger('tap');
			}
			if (typeof o.clinicalEvent === "undefined" || o.clinicalEvent === null) {
				// show loading popup
				$.mobile.loading('show', {text: "Loading Progress Note", textVisible: true});
				// before render
				o.templates = this._templates().get();
				this.$el = $().add(o.templates.main);
				// initialize model
				this._bootstrapClinicalEvent();
				// render and show
				if (!$(o.page).hasClass('ui-panel')) {
					this._buildMain( function() {
						// on success
						that._autoSave();
						$(o.page).panel("open");
						that._trigger("afterOpen", null);
					}, null, function() {
						// always
						$.mobile.loading('hide');
					});
				}
			} else {
				$(o.page).panel("open");
				this._trigger("afterOpen", null);
			}
		},
		close: function(){
			$(this.options.page).panel("close");
			this._stopAutosave();
		},
		registerWidget: function(widget) {
			var o = this.options,
				that = this,
				widgetName = widget.widgetEventPrefix;
				o.childCreated[widgetName] = true;
			if (widgetName !== "sign") {
				$(o.page).on(widgetName, function(e, val){
					that._gatherClinicalEvent(widgetName, (typeof val.options !== "undefined") ? val.options : widget.options, val.pass);
				});
			}
		},
		destroy: function(){
			var $page = $(this.options.page),
				that = this,
				_destroy = function() {
					$("#save-note-popup").popup('destroy');
					$("#save-note-popup").remove();
					that._destroyChildWidgets(); // ? childCreated is "undefined"
					that.options.clinicalEvent = null;
					$page.remove();
				};

			if ($('.ui-panel-content-wrap').hasClass('ui-panel-content-wrap-closed')) {
				_destroy();
			} else { // runs when the panel is closed after signing
				$page.one('panelclose', function() {
					_destroy();
					$page.off();
				});

				this.close();
			}
		},
		_destroyChildWidgets: function() {
			var childCreated = this.options.childCreated;

			if (typeof childCreated !== "undefined") {
				if (childCreated.note) {
					$('#note-section').note('destroy');
					//$('#note-section').empty();
				}
				if (childCreated.link) {
					$('#link-section').link('destroy');
					//$('#link-section').empty();
				}
				if (childCreated.encounter) {
					$('#encounter-section').encounter('destroy');
					//$('#encounter-section').empty();
				}
				if (childCreated.sign) {
					$('#sign-section').sign('destroy');
					//$('#sign-section').empty();
				}
			}
		},
		// initialize model
		_bootstrapClinicalEvent: function(){
			var o = this.options,
				user = o.user,
				defaultProvider;
			o.clinicalEvent = $.extend(true, {}, o.defaults.clinicalEvent);
			o.pass = $.extend(true, {}, o.defaults.pass);
			o.childCreated = $.extend(true, {}, o.defaults.childCreated);

			// provider
			o.clinicalEvent.providerIdentifier.staffId = o.user.id;
			o.clinicalEvent.providerIdentifier.facilityCode = o.user.vistaLocation;
			defaultProvider = {
				primary: true,
				facilityProvider: {
					providerIen: user.id,
					facilityCode: user.vistaLocation,
					providerName: user.lastName + ", " + user.firstName
				},
				selected: true
			};

			o.clinicalEvent.encounter.providers = [defaultProvider];

			// patient
			o.clinicalEvent.patientIdentifier = o.patient.patientIdentifier;
			o.clinicalEvent.patientIdentifier.firstName = o.patient.firstName;
			o.clinicalEvent.patientIdentifier.lastName = o.patient.lastName;
			o.clinicalEvent.patientIdentifier.ssn = o.patient.ssn;

			if (o.patient.inpatient) {
				// set inpatient defaults (to current hospital admission)
				this.publicGet(o.patient['patient-admisions-operational'].href, function(){
					var currentAdmission = this.admission[0],
						link = o.clinicalEvent.encounter;

					link.timestamp = new Date(currentAdmission.admissionDate);
					link.locationTitle = currentAdmission.facilityName;
                    link.locationId = currentAdmission.locationId;
					link.currentAdmission = true;
					link.visitType = "Admission";
					link.serviceCategory = "H";
					o.pass.encounter = true;

				});
			}

			// additional parameters from Skin Check, to be generalised for all applets
			if( _.isArray(o.healthFactorsToBeAdded) ) //if you know of a better place to add this please change.
			{
				if(!_.isArray(o.clinicalEvent.healthFactors) ){
					o.clinicalEvent.healthFactors = [];
				}
				o.clinicalEvent.healthFactors.push.apply(o.clinicalEvent.healthFactors, o.healthFactorsToBeAdded);
				o.healthFactorsToBeAdded = [];
			}
			if( (!_.isArray(o.clinicalEvent.healthFactors)) || o.clinicalEvent.healthFactors.length ===0 )
			{
				delete o.clinicalEvent.healthFactors;
			}
		},
		_gatherClinicalEvent: function(key, value, pass){
			var that = this,
				o = this.options;
			switch(key){
				case "note":
					o.pass.note = pass;
					o.clinicalEvent.note = value;
					break;
				case "link":
					if(typeof value.encounter === "undefined" ) {
						o.clinicalEvent.encounter = {};
					} else {
						o.pass.encounter = pass;
						o.clinicalEvent.encounter.serviceCategory = value.encounter.serviceCategory;
						o.clinicalEvent.encounter.linkType = value.encounter.linkType;
						o.clinicalEvent.encounter.locationId = value.encounter.locationId;
						o.clinicalEvent.encounter.appointmentType = value.encounter.appointmentType;
						o.clinicalEvent.encounter.time = value.encounter.time;
						o.clinicalEvent.encounter.date = value.encounter.date;
						o.clinicalEvent.encounter.timestamp = value.encounter.timestamp;
						o.clinicalEvent.encounter.currentAdmission = value.encounter.currentAdmission;
						if (typeof value.encounter.isHistorical !== "undefined") {
							o.clinicalEvent.encounter.isHistorical = value.encounter.isHistorical;
						}
						if(value.encounter.linkType === "newVisit") {
							o.clinicalEvent.encounter.locationTitle = value.encounter.locationTitle;
							o.clinicalEvent.encounter.locationId = value.encounter.locationId;
						} else if (value.encounter.linkType == "Appointment") {
							o.clinicalEvent.encounter.locationId = value.encounter.clinicId;
							o.clinicalEvent.encounter.locationTitle = value.encounter.clinicName;
						} else if (value.encounter.linkType == "Admission") {
							o.clinicalEvent.encounter.locationId = value.encounter.locationId;
							o.clinicalEvent.encounter.locationTitle = value.encounter.facilityName;
						}
					}
					break;
				case "visit":
					o.pass.visitType = pass;
					if(typeof o.clinicalEvent.encounter.visitTypes !== "undefined" && o.clinicalEvent.encounter.visitTypes.length === 0)
					{
						delete o.clinicalEvent.encounter.visitTypes;
					}
					else
					{
						o.clinicalEvent.encounter.visitTypes = value.visitTypes;
					}
					break;
				case "provider":
					o.pass.providers = pass;
					o.clinicalEvent.encounter.providers = value.providers;
					break;
				case "related":
					o.pass.related = pass;
					if (value.visitRelatedTos.length > 0) {
						o.clinicalEvent.encounter.visitRelatedTos = value.visitRelatedTos;
					} else {
						delete o.clinicalEvent.encounter.visitRelatedTos;
					}
					break;
				case "diagnosis":
					o.pass.diagnoses = pass;

					if(value.diagnosisList.length > 0 ) {
						o.clinicalEvent.encounter.diagnosisCodes = value.diagnosisList;
					} else {
						delete o.clinicalEvent.encounter.diagnosisCodes;
					}

					break;
				case "procedures":
					o.clinicalEvent.encounter.procedureCodes = [];

					var selectedProcedures = value.selectedProcedures,
						encounterProcedures = o.clinicalEvent.encounter.procedureCodes,
						encounterProcedure;

					o.pass.procedures = pass;

					if( selectedProcedures.length > 0 ) {
						_.each(selectedProcedures, function(procedure) {
							encounterProcedure = {
								ien: procedure.ien,
								shortDescription: procedure.shortDescription,
								description: procedure.description,
								code: procedure.code
							};
							if (typeof procedure.selectedModifiers !== "undefined" && procedure.selectedModifiers.length > 0) {
								encounterProcedure.modifiers = procedure.selectedModifiers;
							}

							encounterProcedures.push(encounterProcedure);
						});
					} else {
						delete o.clinicalEvent.encounter.procedureCodes;
					}
					break;
			}
			if (!o.isDraft) { // NOTE: This is hit repeatedly on resume
				o.clinicalEvent.encounterValid = ( (o.pass.visitType && typeof o.clinicalEvent.encounter.visitTypes !== "undefined") || o.pass.procedures ) && o.pass.providers && o.pass.related && o.pass.diagnoses;
			}
			this._validate();
		},
		_validate: function() {
			var that = this,
				o = this.options,
				$sign = $('[data-section-title="sign-section"]'),
				$encounter = $('[data-section-title="encounter-section"]'),
				passEncounterSection = o.clinicalEvent.encounterValid;
			// copied from jQM buttons, as navbar does not have function for individual buttons
			var disableNavButton = function(button) {
					button.attr( "disabled", true );
					button.addClass( "ui-disabled" ).attr( "aria-disabled", true );
				},
				enableNavButton = function(button) {
					button.attr( "disabled", false );
					button.removeClass( "ui-disabled" ).attr( "aria-disabled", false );
				};
			if (o.isDraft)
				this._validateDraft();
			if (o.pass.encounter && o.pass.note) {
				enableNavButton( $encounter );
				if (o.clinicalEvent.encounter.currentAdmission) {
					if (o.clinicalEvent.encounterEdited && !passEncounterSection ) {
						disableNavButton( $sign );
					} else {
						enableNavButton( $sign );
					}
				} else if (passEncounterSection) {
					enableNavButton( $sign );
				} else {
					disableNavButton( $sign );
				}
			} else {
				disableNavButton( $encounter );
				disableNavButton( $sign );
			}
		},
		_validateDraft:function(){
			var o = this.options,
				$link = $('[data-section-title="link-section"]');

			if ( o.clinicalEvent.encounterEdited ) {
				$link.attr( "disabled", true );
				$link.addClass( "ui-disabled" ).attr( "aria-disabled", true );
			}

			if ( o.clinicalEvent.encounterValid ) {
				o.pass.note = true;
				o.pass.encounter = true;
				o.pass.procedures = true;
				o.pass.providers = true;
				o.pass.related = true;
				o.pass.visitType = true;
				o.pass.diagnoses = true;
			} else {
				// TODO: call gatherClinicalEvent for each one
				if(typeof o.clinicalEvent.note !== "undefined" && typeof o.clinicalEvent.note.title !== "undefined" && typeof o.clinicalEvent.note.body !== "undefined" && typeof o.clinicalEvent.note.title.ien !== "undefined"  && typeof o.clinicalEvent.note.title.name !== "undefined" && o.clinicalEvent.note.body !== "" && o.clinicalEvent.note.title.ien !== "" && o.clinicalEvent.note.title.name !== "")
				{
					o.pass.note = true;
				}
				if(typeof o.clinicalEvent.encounter.timestamp !== "undefined" && typeof o.clinicalEvent.encounter.locationId !== "undefined" && o.clinicalEvent.encounter.timestamp !== "" && o.clinicalEvent.encounter.locationId !== "")
				{
					o.pass.encounter = true;
				}
				if(typeof o.clinicalEvent.encounter.procedureCodes !== "undefined")
				{
					o.pass.procedures = true;
				}
				if(typeof o.clinicalEvent.encounter.providers !== "undefined")
				{
					o.pass.providers = true;
				}
				if(typeof o.clinicalEvent.encounter.visitRelatedTos !== "undefined")
				{
					o.pass.related = true;
				}
				if(typeof o.clinicalEvent.encounter.visitTypes !== "undefined")
				{
					o.pass.visitType = true;
				}
				if(typeof o.clinicalEvent.encounter.diagnosisCodes !== "undefined")
				{
					o.pass.diagnoses = true;
				}
			}

			o.isDraft = false;
		},
		// Set up the widget
		_create: function(){
			this._helpers();
		},
		// create panel, create first view in panel
		_buildMain: function(onSuccess, onFail, thenAlways){
			var that = this,
				o = this.options;
			$.when( that._getResumeData() )
				.done( function(data) {
					// set resume data
					if (typeof data !== "undefined" && data.note ) {
						// TODO: move the normalizing into the normalize funciton, hahaha
						//that._normalizeResumeData(data);
						that._setOption("isDraft", data.clinicalEventState.toLowerCase() === "draft" );
						$.extend(that.options.clinicalEvent, data);
						if (o.encounterEdited) {
							$page.off('.editedEncounter');
						}
					}

					// render and show
					$('.ui-page-active').append(that.$el);
					that._render( function() {
						$(o.page)
							.trigger('create')
							.panel({
								position:"right",
								display:"reveal",
								dismissible: false
							});
						that._delegateEvents();

						$('#note-section').note({patient: o.patient, parentElement: that.element, links: o.links});

						$(window).trigger("resize");
						if($.isFunction(onSuccess)) {
							onSuccess.call(that);
						}
					});
				})
				.fail( function() {
					if($.isFunction(onFail)) {
						onFail.call(that);
					}
				})
				.always( function() {
					if($.isFunction(thenAlways)) {
						thenAlways.call(that);
					}
				});
		},
		update: function( arg ){
			var that = this,
				$noteBtn = this.element,
				hasDeferredOpen = false;

			$noteBtn.off();
			$noteBtn.on('tap.deferToggle keyup.deferToggle', function() {
				hasDeferredOpen = !hasDeferredOpen;
				if (hasDeferredOpen) {
					$.mobile.loading('show', {text: "Loading Progress Note", textVisible: true});
				} else if ($('body .ui-loader').filter(':first').text() === "Loading Progress Note") {
					$.mobile.loading('hide');
				}
			});

			this.destroy();
			$.extend(that.options, arg);
			this._initialize().done(function() { // in _initialize, _drawNoteBtn binds toggle
				$noteBtn.off('tap.deferToggle keyup.deferToggle');
				if (hasDeferredOpen) {
					that.open();
				}
			});
		},
		addNote: function( arg ){
			this.options.noteBodyToBeAdded = arg.body;
			this.options.healthFactorsToBeAdded = arg.healthFactors || [];
		},
		_initialize: function(){
			var that = this;

			return this.publicGet(this.options.resourceURI, function(){
				that.options.links = that._flattenLinks(this);
				that._drawNoteBtn();
				that.options.autoSaveInterval = this.autoSaveIntervalinMinutes * 60000;
			});
		},
		_helpers: function() {
			_.mixin({
				indexBy: function(list, func) {
					var length = list.length;
					for (var i = 0, l = length; i < l; i++) {
						if (func(list[i])) return i;
					}
					return -1;
				},
				formatDate: function (date) {
					'use strict';
					date = new Date(date);
					if (typeof date !== 'undefined' && !isNaN(date)) {
						var month = date.getMonth() + 1,
							day = date.getDate(),
							year = date.getFullYear();

						day = day < 10 ? '0' + day : day;
						month = month < 10 ? '0' + month : month;

						return (month + "/" + day + "/" + year);
					}

					return '';
				},
				formatTime: function (date) {
					'use strict';
					var d = new Date(date),
						hh = d.getHours(),
						m = d.getMinutes(),
						s = d.getSeconds(),
						dd = "AM",
						h = hh;

					if (h >= 12) {
						h = hh - 12;
						dd = "PM";
					}

					h = h === 0 ? 12 : h;

					m = m < 10 ? "0" + m : m;

					s = s < 10 ? "0" + s : s;

					/* if you want 2 digit hours:
					 * h = h<10?"0"+h:h; */

					return h + ":" + m + " " + dd;
				}
			});
		},
		_drawNoteBtn: function(){
			if(this.options.patient.patientIdentifier.uniqueId !== "" && typeof this.options.patient.patientIdentifier.uniqueId !=='undefined'){
				var $noteBtn = this.element,
					that = this;

				var template = that._templates().init(),
					$noteBtnText = $noteBtn.find('.ui-btn-text');
				$noteBtnText.empty();
				$noteBtnText.append(template.title.single);

				$noteBtn.off();
				$noteBtn.bind('tap', function(e){
					e.preventDefault();
					that.toggle();
				});
				$noteBtn.bind('keydown', function(e){
					var key = e.which;
					if(key === 13 || key === 32){ // Enter || Space Bar
						e.preventDefault();
						that.toggle();
					}
				});
			}
		},
		toggle: function() {
			if ($(this.options.page).hasClass('ui-panel-open')){
				this.close();
			} else {
				this.open();
				this.options.autoSavePreviousObject = JSON.stringify(this.options.clinicalEvent);
			}
		},

		// Use the _setOption method to respond to changes to options
		_setOption: function(key, value){
			var o = this.options;
			switch(key){
				case "note":
					o.clinicalEvent.note.body = value.body;
					o.clinicalEvent.note.title = value.title;
					break;
				case "link":
					o.clinicalEvent.link = value;
					break;
				case "isDraft":
					o.isDraft = value;
					break;
			}
		},
		_render: function(callbackFn){
			var templates = this.options.templates,
				html = [];
			html.push([
				templates.header,
				templates.content
				].join(''));
			this.$el.empty().append(html);
			if($.isFunction(callbackFn))
				callbackFn.call();
		},
		_getResumeData: function(){
			var that = this,
				o = that.options;

			return $.ajax({
				headers: {
					Accept: "application/json",
					'Content-Type': "application/json;charset=UTF-8"
				},
				type: 'GET',
				url: o.links['note-writer-clinical-events'].href+ '/latest',
				error: function(XMLHttpRequest, textStatus, errorThrown){
					console.log(XMLHttpRequest);
				}
			});
		},
		getNote: function(){
			var that = this,
				o = this.options,
				note = this.options.clinicalEvent.note;
			note.body = (note.body || "") + (this.options.noteBodyToBeAdded||"");
			var n = {
				title: typeof note.title === "undefined" ? "" : note.title,
				consultIen: typeof note.consultIen === "undefined" ? "" : note.consultIen,
				body: (typeof note.body === "undefined" ? "" : note.body)
			};
			if( this.options.noteBodyToBeAdded && this.options.noteBodyToBeAdded !== "") {
				// TODO: save because an app just pushed a note. for resume
				this._autosavePush();
			}
			this.options.noteBodyToBeAdded = "";
			return n;
		},
		getLink: function(){
			var o = this.options.clinicalEvent.encounter,
				link = {
					currentAdmission: typeof o.currentAdmission === "undefined"? "":o.currentAdmission,
					isHistorical: typeof o.isHistorical === "undefined"? "":o.isHistorical,
					linkType: typeof o.linkType === "undefined"? "":o.linkType,
					locationId: typeof o.locationId === "undefined"? "":o.locationId,
					locationTitle: typeof o.locationTitle === "undefined"? "":o.locationTitle,
					time: typeof o.time === "undefined"? "":o.time,
					date: typeof o.date === "undefined"? "":o.date,
					serviceCategory: o.serviceCategory === "undefined"? "": o.serviceCategory,
					timestamp: typeof o.timestamp === "undefined" ? "": o.timestamp
				};

			return link;
		},
		getEncounterInfo: function(){
			return {'object':this.options.clinicalEvent.encounter, 'isDraft': this.options.isDraft};
		},
		getVisit: function(){
			var that = this,
				o = this.options,
				encounter = this.options.clinicalEvent.encounter;
			if(typeof encounter.visitTypes === "undefined")
			{
				encounter.visitTypes = [];
			}
			return {'object': encounter.visitTypes, 'isDraft': o.isDraft};

		},
		getProviders: function(){
			var that = this,
				o = this.options,
				encounter = this.options.clinicalEvent.encounter;
			if(typeof encounter.providers === "undefined")
				{
					encounter.providers = [];
				}
			return {'object':encounter.providers, 'isDraft': o.isDraft};

		},
		getRelatedInfo: function(){
			var that = this,
				o = this.options;
			return typeof o.clinicalEvent.encounter.visitRelatedTos === "undefined"?[]:o.clinicalEvent.encounter.visitRelatedTos;
		},
		getDiagnosesInfo: function(){
			var that = this,
				o = this.options;
			return typeof o.clinicalEvent.encounter.diagnosisCodes === "undefined"?[]:$.extend(true, [],o.clinicalEvent.encounter.diagnosisCodes);
		},
		getProceduresInfo: function(){
			var that = this,
				o = this.options;
			return typeof o.clinicalEvent.encounter.procedureCodes === "undefined"?[]:{'object':o.clinicalEvent.encounter.procedureCodes, 'isDraft': o.isDraft};

		},
		_delegateEvents: function(){
			var that = this,
				o = this.options,
				$page = $(o.page);

			$page.on('tap click', '.ui-accessible-autocomplete a', function(e) {
				e.preventDefault();
			});

			$page.on('change.editedEncounter click.editedEncounter tap.editedEncounter', '#encounters-container input, #diagnoses-filter, #procedures-filter', function(e) {
				o.clinicalEvent.encounterEdited = true;
				$page.off('.editedEncounter');
			});
			$page.on('keydown.editedEncounter', '#encounters-container input, #diagnoses-filter, #procedures-filter', function(e) {
				if (e.type === 'keydown' && (e.which !== 13 || e.which !== 32) ) { return; } // else
				o.clinicalEvent.encounterEdited = true;
				$page.off('.editedEncounter');
			});


			// copied from jQM buttons, as navbar does not have function for individual buttons
			var disableNavButton = function(button) {
				button.attr( "disabled", true );
				button.addClass( "ui-disabled" ).attr( "aria-disabled", true );
			};
			$page.on('tap.setLink', '[data-section-title="encounter-section"]:not([disabled="disabled"]), [data-section-title="sign-section"]:not([disabled="disabled"])', function() {
				disableNavButton( $('[data-section-title="link-section"]') );
				$page.off('.setLink');
			});
			$page.on('keydown.setLink', '[data-section-title="encounter-section"]:not([disabled="disabled"]), [data-section-title="sign-section"]:not([disabled="disabled"])', function(e) {
				if (e.which === 13 || e.which === 32) {
					disableNavButton( $('[data-section-title="link-section"]') );
					$page.off('.setLink');
				}
			});

			$page.on('tap', '#save-notes-btn', function(e){
				savenotes(e);
			});

			$page.on('keydown', '#save-notes-btn', function(e){
				if(e.which === 13 || e.which === 32)
					savenotes(e);
			});

			var savenotes = function(e){
				var postToLink = o.links['note-writer-clinical-events'].href,
					id = o.clinicalEvent.id,
					$savePopup = $('#save-note-popup'),
					showPopup = function() {
						$savePopup.popup({positionTo: "window", overlayTheme: "a", dismissible: false});//#progressNotes-form
						$savePopup.popup('open');
						setTimeout( function(){
							$savePopup.popup('close');
						}, 1500);
					};

				if (o.clinicalEvent.id === "") {
					$('#save-note-popup').find('h3').text("Note Saved");
					that.save(o.clinicalEvent, postToLink, 'POST', function() {
						o.clinicalEvent.id = this.id;
						o.clinicalEvent.clinicalEventState = this.clinicalEventState;
						o.clinicalEvent.lastModifiedDate = this.lastModifiedDate;
						showPopup();
					});
				} else { // update
					$('#save-note-popup').find('h3').text("Note Updated");
					postToLink += "/id/" + o.clinicalEvent.id;
					that.save(o.clinicalEvent, postToLink, 'PUT', function() {
						o.clinicalEvent.clinicalEventState = this.clinicalEventState;
						o.clinicalEvent.lastModifiedDate = this.lastModifiedDate;
						showPopup();
					});
				}
			};

			var initializeSection = function(e) {
				var sectionTitle = $(e.currentTarget).jqmData('section-title'),
					sectionToToggle = $('#' + sectionTitle);
				$('#progressNotes-form > div').hide();
				sectionToToggle.show();
				switch (sectionTitle){
					case "note-section":
						sectionToToggle.note({patient: o.patient, parentElement: that.element, links: o.links});
						break;
					case "link-section":
						//sectionToToggle.link({patient: o.patient, links: o.links});
						sectionToToggle.link({patient: o.patient, links: o.links, 'parentElement': that.element, 'user': that.options.user, previousNote: o.clinicalEvent.encounter});
						break;
					case "encounter-section":
						sectionToToggle.encounter({patient: o.patient, parentElement: that.element, links: o.links, user: o.user, clinicEvent: o.clinicalEvent});
						break;
					case "sign-section":
						sectionToToggle.sign({parentElement: that.element, clinicalEvent: o.clinicalEvent, links: o.links});
						sectionToToggle.sign('init');
						break;
					default:
				}
			};
			$page.on('tap', '.breadcrumb a', function(e){
				e.preventDefault();
				if ($(e.currentTarget).is(':not([disabled="disabled"])')) {
					initializeSection(e);
				}
			});
			$page.on('keydown', '.breadcrumb a', function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					e.preventDefault(); // also prevents eventual call to restyle active button in navbar
					if ($(e.currentTarget).is(':not([disabled="disabled"])')) {
						$(e.currentTarget).trigger('vclick'); // trigger restyle
						initializeSection(e);
					}
				}
			});
		},
		_writeToStorage: function(key, value){
			if(value){
				try{
					window.localStorage[key] = JSON.stringify(value);
				} catch(e){
					if(e == QUOTA_EXCEEDED_ERR){
						var message = 'Local-Storage Quota exceeded!';
						if(window.console && window.console.log){
							console.log(message);
						}
						else{
							alert(message);
						}
					}
				}
			}
		},
		_readFromStorage: function(key){
			var value = null;
			if(typeof(window.localStorage) != 'undefined'){
				value = JSON.parse(window.localStorage[key] || null);
			}
			return value;
		},
		_removeFromStorage: function(key){
			if(typeof(window.localStorage) != 'undefined'){
				window.localStorage.removeItem(key);
			}
		},
		_autoSave: function(){
			var that = this;


			this._stopAutosave();
			that.options.autoSaveTimeout = setTimeout( function(){return that._autosavePush.apply(that,[]);}, that.options.autoSaveInterval);

		},
		_autosavePush:function(){
			var o = this.options,
				clinicEvent = o.clinicalEvent,
				postToLink = o.links['note-writer-clinical-events'].href,
				previousAutosave = o.autoSavePreviousObject,
				currentNote = o.clinicalEvent;

			if( previousAutosave !== JSON.stringify(currentNote) )
			{
				if (clinicEvent.id === "") {
					this.save(clinicEvent, postToLink, 'POST', function(){
						currentNote.id = this.id;
						currentNote.clinicalEventState = this.clinicalEventState;
						currentNote.lastModifiedDate = this.lastModifiedDate;
					});
				} else { // update
					postToLink += "/id/" + currentNote.id;
					this.save(clinicEvent, postToLink, 'PUT', function(){
						currentNote.clinicalEventState = this.clinicalEventState;
						currentNote.lastModifiedDate = this.lastModifiedDate;
					});
				}
				previousAutosave = JSON.stringify(currentNote);
			}
			this._autoSave();
		},
		_stopAutosave: function(){
			clearTimeout(this.options.autoSaveTimeout);
		},
		save: function(data, url, type, onSuccess, onFail){
			var that = this,
				isSign = (url === that.options.links.sign.href);
			$.ajax({
				accepts: {json: 'application/json'},
				url: url,
				type: type,
				data: JSON.stringify(data),
				contentType: 'application/json;charset=UTF-8',
				dataType: 'json',
				success: function(response){
					if($.isFunction(onSuccess)) {
						onSuccess.call(response);
					}
					if (!isSign) {
						that._trigger("onSave", null);
					} else {
						that._trigger("onSign", null);
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					// this needs to check if it is an autosave
					console.log("Error on autosave: " + XMLHttpRequest);
					if($.isFunction(onFail)) {
						onFail.call(XMLHttpRequest, textStatus, errorThrown);
					}
				}
			});
		},
		publicGet: function(url, onSuccess, onFail){
			return $.ajax({
				accepts: {json: 'application/json'},
				type: 'GET',
				url: url,
				dataType: 'json',
				success: function(data){
					if($.isFunction(onSuccess))
						onSuccess.call(data);
				},
				error: function(XMLHttpRequest, textStatus, errorThrown){
					console.log(XMLHttpRequest);
					if($.isFunction(onFail)) {
						if ( /^</.test(XMLHttpRequest.responseText) ) {
							XMLHttpRequest.responseText = '{ "message": "Unable to connect to Vista system" }';
						}
						onFail.call(XMLHttpRequest, textStatus, errorThrown);
					}
				}
			});
		},
		_flattenLinks: function(object){
			var links = object.link;
			if(typeof links !== 'undefined'){
				size = links.length;

				for(var i = 0; i < size; i++){
					if(links[i].title){
						object[links[i].title] = links[i];
					}
					else{

						object[links[i]] = links[i];
					}
				}
			}
			delete object.link;
			return object;
		},
		_app: function(){
			'use strict';
			var o = this.options,
				views = {
					noteBtn: function(){
						var View = Backbone.View.extend({
							initialize: function() {
							},
							render: function() {
							}
						});
						return new View();
					}
				};
			return {
				getViews: function(){
					return views;
				},
				getModels: function(){
					return models;
				}
			};
		},

		/* populate an autocomplete, via a publicGet and show */
		showAutocompleteList: function (templateItem) {
			templateItem = (typeof templateList === "undefined") ? autocompleteList : templateList;
			templateList = (typeof templateItem === "undefined") ? autocompleteListItem : templateItem;
		},
		_templates: function(){
			/*jshint multistr: true */

			/* HELPERS */
			var capitalizeFirstLetter = function(string){
				'use strict';
				string = string.toLowerCase();
				return string.charAt(0).toUpperCase() + string.slice(1);
			};

			var o = this.options,
				initButton = {
					title: {
						single: 'Note',
						plural: 'Notes'
					},
					count: '<span class="ui-li-count ui-btn-up-c ui-btn-corner-all">' + o.inprogress + '</span>'
				},
				templates = {
					main: '<div id="' + o.page.replace('#', '') + '" data-role="panel" class=""></div>',
					header: '<div data-role="header" class="ui-header ui-bar-b" data-theme="b"> \
							<h3 class="ui-title" role="heading" aria-level="1">Progress Note</h3> \
							<a id="save-notes-btn" class="ui-btn-right" href="#" data-inline="true" data-icon="lv-large-check" data-role="button" data-theme="d">Save</a> \
							<div data-role="popup" id="save-note-popup"> \
								<h3>Note Saved</h3> \
							</div> \
						</div> \
						<div data-role="navbar" class="breadcrumb"> \
							<ul>\
								<li><a href="#" class="ui-btn-active" data-section-title="note-section">Note</a></li> \
								<li><a href="#" data-section-title="link-section">Link</a></li> \
								<li><a href="#" class="ui-disabled" data-section-title="encounter-section">Encounter</a></li> \
								<li><a href="#" class="ui-disabled" data-section-title="sign-section">Sign</a></li> \
							</ul> \
						</div>',
					content: '<div data-role="content" class="scrollable"> \
								<fieldset data-mini="true" id="progressNotes-form"> \
									<div id="note-section">\
									</div> \
									<div id="link-section"> \
									</div> \
									<div id="encounter-section"> \
									</div> \
									<div id="sign-section"> \
									</div> \
								</fieldset> \
							</div>'
				};
			return {
				get: function(){
					return templates;
				},
				init: function(){
					return initButton;
				}
			};
		}
	});



	$.widget("mobile.link", {
		// These options will be used as defaults
		options: {
			defaults: {
				clinicLinks: [],
				hospitalLinks: [],
				autocompleteList: [],
				autocompleteURI: "",
				encounter: {
				},
				//validated: false,
				resumed: false
			}
		},
		_setOption: function(key, value){
			var that = this,
				o = this.options;
			switch (key){
				case 'autocompleteURI':
					o.autocompleteURI = value;
					break;
				case 'encounter':
					o.encounter = value;
					break;
				case 'clinicLinks':
					o.clinicLinks = value;
					break;
				case 'hospitalLinks':
					o.hospitalLinks = value;
					break;
				case 'autocompleteList':
					o.autocompleteList = value;
					break;
				case 'locationTitle':
					o.locationTitle = value;
					break;
				case 'resumed':
					o.resumed = value;
					break;
				case 'selectLink':
					o.encounter = value;
					o.encounter.linkType = value['object-type'];
					if (o.encounter.linkType === "Admission") {
						o.encounter.timestamp = new Date(value.admissionDate);
					} else if (o.encounter.linkType === "Appointment") {
						o.encounter.timestamp = new Date(value.appointmentStartDate);
					} else {
						o.encounter.timestamp = "";
					}
					break;
				case 'selectTime':
					o.encounter.time = value;
					if ( typeof o.encounter.date !== "undefined" && typeof o.encounter.time !== "undefined" && o.encounter.date !== "" && o.encounter.time !== "" ) {
						o.encounter.timestamp = new Date (o.encounter.date + " " + o.encounter.time);
					}
					break;
				case 'selectDate':
					o.encounter.date = value;
					if ( typeof o.encounter.date !== "undefined" && typeof o.encounter.time !== "undefined" && o.encounter.date !== "" && o.encounter.time !== "" ) {
						o.encounter.timestamp = new Date (o.encounter.date + " " + o.encounter.time);
					}
					break;
				case 'selectLocation':
					o.encounter.locationTitle = value.name;
					o.encounter.locationId = value.id;
					o.encounter.facilityCode = value.facilityCode;
					o.encounter.linkType = "newVisit";
					break;
				case 'linkType':
					o.encounter.linkType = value;
					break;
				case 'selectHistorical':
					o.encounter.isHistorical = value;
					o.encounter.linkType = "newVisit";
					break;
				case 'currentAdmission':
					o.encounter.currentAdmission = value;
					break;
				case 'isValid':
					this.element.trigger(this.widgetEventPrefix, {pass: value});
					break;
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var that = this,
				o = this.options,
				section = $('#link-section'),
				template = this._templates().get(),
				admitted = this.options.patient.inpatient;

			this.options.parentElement.progressNotes('registerWidget', this);

			that.options.parentElement.progressNotes('publicGet', that.options.user['location-service-resource-directory'].href, function() {
				_.find(this.link,function(item){
					if( item.title === "clinics-operational")
					{
						that._setOption("autocompleteURI", item.href);
						return true;
					}
				});
			});

			// render
			section.append(_.template(template.main)({'linkType': this.options.encounter.linkType, 'isHistorical': this.options.encounter.isHistorical})).trigger('create');
			$('#select-date').mobile508datepicker({
				"leading-zero": true,
				beforeToday: true,
				onClose: that._changeDate
			});
			$('#select-time').mobile508timepicker({
				onClose: that._changeTime
			});

			this._resume();
			if (!this.options.resumed && admitted) {
				that._setOption('linkType', 'Admission');
				$('#link-appointment-section [data-role=collapsible]:nth-of-type(2)').collapsible('option', 'collapsed', false).trigger('expand');
			}
			// TODO: inserting classes for testing;
			// remove after accessible-autocomplete widget is in, as it will include these classes
			$('#select-location').wrapAll( $('<div class="ui-listview-wrapper ui-accessible-autocomplete-wrapper ui-scrollable-wrapper"><div class="ui-scrollable"></div></div>') );
			$("#new-visit-section .ui-listview-filter").addClass("ui-accessible-autocomplete-filter ui-accessible-autocomplete-filter-inset");
			$("#new-visit-section .ui-listview:jqmData(filter='true')").addClass("ui-accessible-autocomplete ui-accessible-autocomplete-inset");

			this._populateLinkLists();

			this._validate();

			this._delegateEvents();
		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			// used by accessibleCalendar
			$('#date-picker').popup('destroy');
			$('#date-picker').remove();
			// used by accessibleTime
			$('#time-picker').popup('destroy');
			$('#time-picker').remove();
		},
		_resume: function(){
			var o = this.options,
				link = this.options.parentElement.progressNotes('getLink');
				$sections = $("#link-appointment-section [data-role='collapsible']");

			this._setOption("encounter", link);
			this._setOption("resumed", true);

			if(typeof o.encounter.linkType === "undefined" || o.encounter.linkType === "") {
				this._setOption("resumed", false);
				o.encounter.linkType = "newVisit";
				$sections.eq(2).trigger('expand');
			}
			else if (o.encounter.linkType === "Appointment") {
				this._redrawAppointments();
				$sections.eq(0).trigger('expand');
			}
			else if (o.encounter.linkType === "Admission") {
				this._redrawAdmissions();
				$sections.eq(1).trigger('expand');
			}
			else if (o.encounter.linkType === "newVisit") {
				this._redrawNewVisit();
				$sections.eq(2).trigger('expand');
			}
		},
		/*
		_resumeExistingEncounter: function(list, id){
			var that = this,
				o = this.options,
				inputsFilled = (typeof o.date !== "undefined" && typeof o.time !== "undefined" && typeof o.locationTitle !== "undefined");
			if(!inputsFilled && o.dssId == "" )
			{
				if(typeof o.date === "undefined")
				{
					o.date = "";
				}
				if(typeof o.time === "undefined")
				{
					o.time = "";
				}
				if(typeof o.locationTitle === "undefined")
				{
					o.locationTitle = "";
				}
			}

			else if()
			_.find(list, function(appointment){
				if( appointment.dataIdentifier.uniqueId == id ){
					o.encounter = {};
					that._setOption("selectLink", appointment);
					//that.validate();
					return true
				}
			});
		},*/
		_populateLinkLists: function(){
			var o = this.options,
				that = this,
				//clinicUrl = o.patient['patient-appointments-operational'].href,
				clinicUrl = o.links['note-writer-clinic-appointments'].href,
				hospitializationUrl = o.patient['patient-admisions-operational'].href,
				clinicEvent = o.parentElement,
				template = this._templates().get(),
				listLoading = _.template(template.uiLoading)(),
				listContainer = template.appointmentList,
				pastHospitalizationsList = $(listContainer),
				pastClinicList = $(listContainer),
				listErrorItem = _.template(template.listErrorItem),
				listSystemError = _.template(template.listSystemError);


			// append animation; gets cleared when a response comes back from publicGet
			$('#clinic-appointment-list, #hospital-appointment-list').append(listLoading).trigger('create');

			clinicEvent.progressNotes('publicGet',clinicUrl, function(){
				var data = this,
					size = data.size;

				if(size > 0) {
					that._setOption("clinicLinks",data.appointment);
				} else {
					that._setOption("clinicLinks",[]);
				}
				that._redrawAppointments();
			}, function() {
				pastClinicList.append(listSystemError({ message: $.parseJSON(this.responseText).message }));
				$('#clinic-appointment-list').empty().append(pastClinicList).trigger('create');
			});

			clinicEvent.progressNotes('publicGet', hospitializationUrl, function(){
				var data = this,
					size = data.size;

				if(size > 0) {
					that._setOption("hospitalLinks", data.admission);
				} else {
					that._setOption("hospitalLinks", []);
				}
				that._redrawAdmissions();
			}, function() {
				pastHospitalizationsList.append(listSystemError({ message: $.parseJSON(this.responseText).message }));
				$('#hospital-appointment-list').empty().append(pastHospitalizationsList).trigger('create');
			});
		},
		_redrawNewVisit: function(){
			var o = this.options.encounter;
			$('.location-select input').val(o.locationTitle);
			$('#select-date').val(o.date);
			$('#select-time').val(o.time);
			if(o.isHistorical) {
				var input = $('#historical-visit-checkbox').parent().find('input');
				input.prop("checked", true);
				input.checkboxradio('refresh');
			}
		},
		_redrawAdmissions: function(){
			var that = this,
				o = this.options,
				locationId = o.encounter.locationId,
				timestamp = new Date(o.encounter.timestamp).getTime(),
				template = this._templates().get(),
				listLoading = _.template(template.uiLoading)(),
				listContainer = template.appointmentList,
				pastHospitalizationsList = $(listContainer),
				hospitalListItem = _.template(template.hospitalListItem),
				listErrorItem = _.template(template.listErrorItem),
				inpatient =  o.patient.inpatient,
				hospitalAppointmentList = $('#hospital-appointment-list').empty(),
				links = o.hospitalLinks,
				size = links.length;
			$('#hospital-appointment-list').append(listLoading).trigger('create');
			if(size > 0) {
				for(var i = 0; i < size; i++) {
					var hospitalization = links[i],
						admitted = false;

					if( (i === 0 && inpatient) || ( locationId == hospitalization.locationId && timestamp === new Date(hospitalization.admissionDate).getTime() ) ){
						admitted = true;
						that._setOption("linkType", "Admission");
						that._setOption("selectLink", hospitalization);
						that._validate();
					}

					pastHospitalizationsList.append( hospitalListItem({'appointment': hospitalization, 'locationId': hospitalization.locationId, 'currentAdmission': admitted}) );
				}
			} else {
				pastHospitalizationsList.append(listErrorItem({'sectionName': "Hospital"}));
			}
			hospitalAppointmentList.empty().append(pastHospitalizationsList).trigger('create');
		},
		_redrawAppointments: function(){
			var that = this,
				o = this.options,
				locationId = o.encounter.locationId,
				timestamp = new Date(o.encounter.timestamp).getTime(),
				template = this._templates().get(),
				listLoading = _.template(template.uiLoading)(),
				listContainer = template.appointmentList,
				pastClinicList = $(listContainer),
				clinicListItem = _.template(template.clinicListItem),
				listErrorItem = _.template(template.listErrorItem),
				clinicAppointmentList = $('#clinic-appointment-list').empty(),
				links = o.clinicLinks,
				size = links.length;
			$('#clinic-appointment-list').append(listLoading).trigger('create');
			if(o.clinicLinks.length > 0) {
				for(var i = 0; i < size; i++) {
					var clinicAdmission = links[i];

					if(locationId === clinicAdmission.clinicId && timestamp === new Date(clinicAdmission.appointmentStartDate).getTime()) {
						clinicAdmission.currentAdmission = true; //draw item as selected in list
						that._setOption("linkType","Appointment" );
					} else {
						clinicAdmission.currentAdmission = false; //doNOT draw item as selected in list
					}

					pastClinicList.append( clinicListItem(clinicAdmission) );
				}
			}else {
				pastClinicList.append(listErrorItem({'sectionName': "Clinic"}));
			}
			clinicAppointmentList.empty().append(pastClinicList).trigger('create');

		},
		_changeDate:function(){
			$('#select-date').trigger('change');
		},
		_changeTime:function(){
			$('#select-time').trigger('change');
		},
		_validate: function(){
			var o = this.options,
				isValid = false,
				current = this.options.encounter;

			if( current.linkType === "newVisit") {
				this._validateNewVisit();
				return;
			} else {
				current.isHistorical = false;
				current.appointmentType = current.linkType;
				isValid = true;

				// if the first link
				if ( current.linkType === "Appointment" ) {
					current.serviceCategory = "A";
				} else if ( current.linkType === "Admission" ) {
					current.serviceCategory = "H";
					if ( o.patient.inpatient && o.hospitalLinks.length > 0 && o.hospitalLinks[0].timestamp === o.encounter.timestamp ) {
						this._setOption("currentAdmission", true);
					} else {
						this._setOption("currentAdmission", false);
					}
				} else {
					isValid = false;
				}
			}
			this._setOption("isValid", isValid);
		},
		_validateNewVisit: function(){
			var that = this,
				o = this.options,
				current = o.encounter,
				time = current.time,
				date = current.date,
				locationTitle = current.locationTitle,
				locationId = current.locationId;

			this._setOption("linkType", "newVisit");
			current.appointmentType = 'Appointment';
			if(typeof current.isHistorical !== "boolean") {
				current.isHistorical = false;
				current.serviceCategory = "E";
			} else {
				current.serviceCategory = "A";
			}
			if(typeof time !== "undefined" && typeof date !== "undefined" && typeof locationId !== "undefined" && time !== "" && date !== "" && locationId !== "") {
				that._setOption("isValid", true);
			} else {
				that._setOption("isValid", false);
			}
		},
		_delegateEvents: function(){
			var that = this,
				o = this.options;

			this.element.on('keyup', '.location-select input', function(e){
				var key = e.which,
					autocompleteText = $('.location-select input').val();

				switch(key){
					case 27: //Escape
						e.preventDefault();
						that._hideAutocompleteList();
						break;
					case 38: //up aarow
						if($('.select-location').is(":visible")){
							e.currentTarget.blur();

							var autocompleteList = $('.select-location li:visible').not('[data-role = "list-divider"]');

							autocompleteList.eq(autocompleteList.length-1).find('a').focus();
						}
						break;
					case 40: //down aarow
						if($('.select-location').is(":visible")){
							$('.select-location li:visible').not('[data-role = "list-divider"]').eq(0).find('a').focus();
						}
						break;
					default:
						var autocomplete = $('ul.select-location');

						if(autocompleteText.length >= 3){
							that._newVisitAutocomplete();
						}else{
							autocomplete.hide();
						}
						break;
				}
			});
			this.element.on('tap', 'ul.select-location a', function(e){
				e.preventDefault();
				$('.location-select input').val(e.currentTarget.text);
				that._selectFromAutocompleteList(e);
				$('ul.select-location').hide();
			});
			this.element.on('focus', '.location-select input', function(e){
				var listItems = $('ul.select-location');

				if(listItems.find('li').length > 0 && $('.location-select input').val() !== "")
				{
					listItems.show();
				}
			});
			this.element.on('blur', '.location-select input', function(e){
				that._deselectAppointments();
			});
			this.element.on('keydown', '.select-location li a', function(e){

				var key = e.which;
				switch(key){
					case 13: //Enter
						e.preventDefault();
						if(!$(e.currentTarget).closest('li').hasClass('always-show'))
						{
							that._selectFromAutocompleteList(e);
						}
						break;
					case 27: //Escape
						$('#note-section form input').focus();
						that._hideAutocompleteList();
						break;
					case 32: //Space Bar
						e.preventDefault();
						if(!$(e.currentTarget).closest('li').hasClass('always-show'))
						{
							that._selectFromAutocompleteList(e);
						}
						break;
					case 38: //up aarow
						that._moveUp(e);
						break;
					case 40: //down aarow
						that._moveDown(e);
						break;
				}

			});
			this.element.on('tap', '.appointment-list a', function(e){
				e.preventDefault();
				that._deselectAppointments();
				that._resetNewVisitInputs();
				$(e.currentTarget).closest('li').addClass('ui-btn-active');

			});
			this.element.on('tap', '#hospital-appointment-list a', function(e){
				e.preventDefault();
				var selectedAppointment = $(e.currentTarget).data('id');

				_.find(o.hospitalLinks, function(admission){
					if( parseInt(admission.locationId, 10) === selectedAppointment ){
						o.encounter = {};
						that._setOption("selectLink", admission);
						return true;
					}
				});
				that._validate();
			});
			this.element.on('tap', '#clinic-appointment-list a', function(e){
				e.preventDefault();
				var selectedAppointment = $(e.currentTarget).data('id');

				_.find(o.clinicLinks, function(appointment){
					if( parseInt(appointment.clinicId, 10) === selectedAppointment ){
						o.encounter = {};
						that._setOption("selectLink", appointment);
						return true;
					}
				});
				that._validate();
			});
			this.element.on('tap', '.location-select .ui-input-clear', function(e){
				that._setOption("selectLocation", {
					name: "",
					id: "",
					facilityCode: ""
				});
				that._validateNewVisit();
				that._hideAutocompleteList();
			});
			this.element.on('keyup', '.location-select input', function(e){

				if(typeof that.options.encounter.location !== "undefined" )
				{
					if( e.currentTarget.value !== that.options.encounter.location.name)
					{
						that._setOption("isValid", false );
					}
				}
			});
			this.element.on('change', '#select-time', function(e){
				that._deselectAppointments();
				that._setOption('selectTime', $(this).val() + ":00");
				that._validateNewVisit();
			});
			this.element.on('change', '#select-date', function(e){
				that._deselectAppointments();
				that._setOption('selectDate', $(this).val());
				that._validateNewVisit();
			});
			this.element.on('change', '#historical-visit-checkbox', function(e){
				var isChecked = $(this).prop("checked");
				that._deselectAppointments();
				if(typeof o.encounter.linkType !== "undefined" && o.encounter.linkType !== "newVisit"){
					o.encounter = {};
				}
				that._setOption("selectHistorical", isChecked);
				that._validateNewVisit();

			});
		},
		_selectFromAutocompleteList: function(e){

			var that = this,
				o = that.options,
				selectedAppointment = $(e.currentTarget).text();

			_.find(o.autocompleteList, function(location){
				if( location.name === selectedAppointment ){
					if(typeof o.encounter.linkType !== "undefined" && o.encounter.linkType !== "newVisit"){
						o.encounter = {};
					}
					$('.location-select input').val(location.name);
					that._setOption("selectLocation", location);
					that._validateNewVisit();
					that._hideAutocompleteList();
					return true;
				}
			});

		},
		_deselectAppointments: function(){
			_.each($('.appointment-list a'), function(appointment){
				$(appointment).closest('li').removeClass('ui-btn-active');
			});
			this._setOption("currentAdmission", false);
		},
		_resetNewVisitInputs: function(){
			$('#historical-visit-checkbox').parent().find('input').prop("checked", false).checkboxradio('refresh');
			$('.location-select input').val("");
			$('#select-date').val("");
			$('#select-time').val("");
		},
		_newVisitAutocomplete: function(){

			var locationList= $('ul.select-location'),
				locationInputText = $('.location-select input').val(),
				that = this,
				searchResults='',
				template = this._templates().get(),
				listItem = _.template(template.autocompleteListItem);

			that.options.parentElement.progressNotes('publicGet', that.options.autocompleteURI + "?searchstring=" + locationInputText, function() {
				var size = this.size;
				var autocompletelist = $('.select-location'),
					autocompleteContainerHeight = $('body').outerHeight() - $('#footer').outerHeight() - $('.location-select .ui-input-search').offset().top - $('.location-select .ui-input-search').outerHeight() - parseInt(autocompletelist.css('margin-bottom'), 10);

				autocompletelist.css({"max-height":autocompleteContainerHeight});

				if(size > 0) {
					that._setOption("autocompleteList",this.clinic);
					for(var i = 0; i < size;i++) {
						var clinic = this.clinic[i];
						searchResults += listItem( clinic );
					}
				} else {
					searchResults += template.autocompleteErrorItem;
				}
				locationList.empty().append(searchResults).show();
				locationList.listview('refresh');
			});
		},
		_hideAutocompleteList: function(){
			$('ul.select-location').empty();
		},
		_moveUp: function(e){
			e.preventDefault();
			var elementList = $(e.currentTarget).closest('li').prevAll(":visible").not('[data-role = "list-divider"]');
			topOfList = false;
			if(elementList.length === 0){
				elementList = $(e.currentTarget).closest('li').nextAll(":visible").not('[data-role = "list-divider"]');
				topOfList = true;
			}
			if(elementList.length > 0 && topOfList)
				$(elementList[elementList.length-1]).find('a').focus();

			else if(elementList.length > 0 && !topOfList)
				$(elementList[0]).find('a').focus();

			else{
				$('.location-select input').focus();
			}
		},
		_moveDown: function(e){
			e.preventDefault();
			var elementList = $(e.currentTarget).closest('li').nextAll(":visible").not('[data-role = "list-divider"]'),
				bottomOfList = false;
			if(elementList.length === 0){
				elementList = $(e.currentTarget).closest('li').prevAll(":visible").not('[data-role = "list-divider"]');
				bottomOfList = true;
			}

			if(elementList.length > 0 && bottomOfList)
				$(elementList[elementList.length-1]).find('a').focus();

			else if(elementList.length > 0 && !bottomOfList)
				$(elementList[0]).find('a').focus();

			else{
				$('#note-section form input').focus();
			}

		},
		_templates: function(){
			/*jshint multistr: true */
			var templates = {
				main: '<div id="link-appointment-section" data-role="collapsible-set" data-mini="true" data-theme="b" data-content-theme="d" data-collapsed="false" data-iconpos="right" class="inset-select-list"> \
							<div data-role="collapsible" <% if(linkType === "Appointment"){ %>data-collapsed="false" <% } %>> \
								<h3>Clinic Appointment</h3> \
								<div id="clinic-appointment-list" class="appointment-list">\
								</div> \
							</div> \
							<div data-role="collapsible" <% if(linkType === "Admission"){ %>data-collapsed="false" <% } %>> \
								<h3>Hospital Admission</h3> \
								<div id="hospital-appointment-list" class="appointment-list">\
								</div> \
							</div> \
							<div data-role="collapsible" <% if(linkType === "newVisit"){ %>data-collapsed="false" <% } %>class="reset-collapsible-padding ui-mini"> \
								<h3>New Visit</h3> \
								<div id="new-visit-section"> \
									<div id="create-new-visit-container" class="ui-grid-a"> \
										<div class="ui-block-a"> \
											<label for="select-time" class="ui-controlgroup-label">Time of Visit:</label> \
												<input type="text" id="select-time" readonly name="select-time" /> \
										</div> \
										<div class="ui-block-b"> \
											<label for="select-date" class="ui-controlgroup-label">Date of Visit:</label> \
												<input type="text" id="select-date" readonly name="select-date" /> \
										</div> \
									</div> \
									<div class="location-select"> \
										<label for="select-location" class="ui-controlgroup-label">Location:</label> \
										<ul id="select-location" data-role="listview" name="title" data-icon="false" class="select-location autocomplete-list" data-filter="true" data-inset="true" data-filter-placeholder="Enter a location..." data-filter-theme="d"></ul> \
									</div>\
									<div  data-role="fieldcontain" class="historical-visit-checkbox"> \
										<fieldset data-role="controlgroup"> \
											<input id="historical-visit-checkbox" type="checkbox" name="historical-visit-checkbox"  class="custom" data-mini="true"/> \
											<label for="historical-visit-checkbox">Historical Visit</label> \
										</fieldset> \
									</div> \
								</div> \
							</div> \
						</div>',
				uiLoading: '<div class="ui-loading"><h3>Loading</h3><span class="ui-sending"></span></div>',
				autocompleteListItem: '<li><a href="#" name="<%= id %>"><%= name %></a></li>',
				autocompleteErrorItem: '<li data-role="list-divider">No Clinics Found</li>',
				appointmentList: '<ul data-role="listview" data-icon="false" class="association-list" data-theme="c"> </ul>',
				clinicListItem: '<li <% if(currentAdmission){ %>class="ui-btn-active"<% } %>><a href="#" data-id="<%= clinicId %>"><h3><%= clinicName %></h3><span class="ui-li-aside"><%= _.formatDate(appointmentStartDate)%> <%= _.formatTime(appointmentStartDate) %></span></a></li>',
				hospitalListItem: '<li <% if(currentAdmission){ %>class="ui-btn-active"<% } %>><a href="#" data-id="<%= locationId %>" data-current-admission="<%= currentAdmission %>"><h3><%= appointment.facilityName %></h3><span class="ui-li-aside"><%= _.formatDate(appointment.admissionDate)%> <%= _.formatTime(appointment.admissionDate) %><% if (typeof appointment.dischargeDate !== "undefined" && appointment.dischargeDate !== "") { %><br /><%= _.formatDate(appointment.dischargeDate)%> <%= _.formatTime(appointment.dischargeDate) %><% } %></span><p><%= appointment["object-type"] %></p></a></li>',
				listErrorItem: '<li><% if(typeof message !== "undefined"){ %><%= message %><% } else { %> No <%= sectionName %> Events Found<% } %></li>',
				listSystemError: '<li><%= message %></li>'
			};

			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.note", {
		// These options will be used as defaults
		options: {
			defaults: {
				title: {
					ien: "",
					name: "",
					isConsult: ""
				},
				body: "",
				consultIen: "",
				signedDate: "",
				consultsList: [],
				searchResultsList: [],
				previousTitleListItem: {}
			}
		},
		_setOption: function(key, value){
			var o = this.options;

			switch(key){
				case "title":
					if ( typeof value !== "undefined" ) {
						o.title = {
							ien: value.ien || "",
							name: value.name,
							isConsult: value.isConsult || false
						};
					} else {
						o.title = {
							ien: "",
							name: "",
							isConsult: false
						};
					}
					break;
				case "consultIen":
					if ( typeof value !== "undefined" ) {
						o.consultIen = value.toString();
					} else {
						o.consultIen = "";
					}
					break;
				case "body":
					if ( typeof value !== "undefined" ) {
						o.body = value;
					}
					break;
				case "consultsList":
					if ( typeof value !== "undefined" ) {
						o.consultsList = value;
					} else {
						o.consultsList = [];
					}
					break;
				case "searchResultsList":
					if ( typeof value !== "undefined" ) {
						o.searchResultsList = value;
					} else {
						o.searchResultsList = [];
					}
					break;
				case "previousTitleListItem":
					if ( typeof value !== "undefined" ) {
						o.previousTitleListItem = {
							ien: value.ien,
							name: value.name,
							isConsult: value.isConsult
						};
					} else {
						o.previousTitleListItem = {};
					}
					break;
				default:
					break;
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var that = this,
				section = this.element,
				template = this._templates().get(),
				o = this.options,
				title = o.title.name,
				consultsUrl = o.patient['patient-consults-operational'].href;

			this.options.parentElement.progressNotes('registerWidget', this);

			// Resume
			this._resume();

			section.html(template.main).trigger('create');
			$("#note-title-autocomplete").accessibleautocomplete();
			$("#note-section .ui-accessible-autocomplete-filter input").attr({id: 'note-title'});

			this._redrawTitle();
			this._redrawBody();

			// Get previously selected title
			o.parentElement.progressNotes('publicGet', o.links['last-selected-note-title'].href, function() {
				if( $(this).length > 0 && typeof this.ien !== 'undefined' && typeof this.name !== 'undefined' ) {
					that._setOption('previousTitleListItem', this);
				} else {
					that._setOption('previousTitleListItem');
				}
			});

			// Get consults
			o.parentElement.progressNotes('publicGet', consultsUrl, function() {
				var noConsultItem = _.template(template.noConsultListItem),
					consultItem = _.template(template.consultListItem),
					listItems = noConsultItem(),
					date,
					month,
					day;


				if (this.size > 0) {
					that._setOption( 'consultsList', _.filter(this.consult, function(consult) {
						return consult.status.toLowerCase() !== "cancelled";
					}) );

					_.each(o.consultsList, function(consult) {
						date = new Date(consult.createdDate);
						month = date.getMonth() + 1;
						day = date.getDate();

						consult.timestamp = (month < 10 ? '0' + month : month) + '/' + (day < 10 ? '0' + day : day) + '/' + date.getFullYear();
					});
				} else {
					that._setOption( 'consultsList' );
				}

				if (o.consultsList.length > 0) {
					listItems = "";

					_.each(o.consultsList, function(consult) {
						listItems += consultItem(consult);
					});
				}

				$('#note-select-consult ul').append(listItems);
				$('#note-select-consult ul').listview('refresh');
			}, function() {
				var noConsultItem = _.template(template.noConsultListItem);

				listItems = noConsultItem({ message: this.message });

				$('#note-select-consult ul').append(listItems);
				$('#note-select-consult ul').listview('refresh');
			});

			this._delegateEvents();
			this._validate();
			$(document).on('progressnotesafteropen.noteupdate', o.parentElement, function( e, ui ) {
				that.update();
			});
		},
		destroy: function() {
			this._destroyChildWidgets();
			$(document).off('progressnotesafteropen.noteupdate');
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			$(document).off('tap', '#note-select-consult li a');
			$(document).off('popupafterclose', '#note-select-consult');

			$('#note-select-consult').popup('destroy');
			$('#note-select-consult').remove();
		},
		_validate: function() {
			var o = this.options,
				// to avoid passing up patient and parentWidget
				note = {
					title: o.title,
					body: o.body,
					consultIen: o.consultIen
				},
				errorMessage = $('.error-message');

			if (note.title.ien === "" && note.title.name !== "") {
				errorMessage.text("Please select a valid note title");
			} else if (note.title.isConsult && note.consultIen === "") {
				errorMessage.text("Please select a consult");
			} else {
				errorMessage.text("");
			}

			if (!note.title.isConsult) {
				delete note.consultIen;
			}

			this.element.trigger(this.widgetEventPrefix, {
				pass: ( note.title.ien !== "" && note.body.trim() !== "" ),
				options: note
			});
		},
		_resume: function(){
			var o = this.options,
				resumedNote = this.options.parentElement.progressNotes('getNote');

			this._setOptions({
				title: resumedNote.title,
				consultIen: resumedNote.consultIen,
				body: resumedNote.body
			});
		},
		update: function(){
			this._resume();
			this._redrawBody();
//			debugger;
//			this._setOptions({
//				body: resumedNote.body,
//			});
		},
		_redrawTitle: function(){
			var o = this.options;
			$('#note-title').val(o.title.name);
		},
		_redrawBody: function(){
			$('#note-section #note-body').val(this.options.body);
		},
		_delegateEvents: function(){
			var that = this,
				o = this.options,
				$section = $(this.element),
				autocompleteCallback = this._autocomplete();

			// note title autocomplete
			$section.on('click', '.ui-listview-filter .ui-input-clear', function(e) {
				// search.val('') already handled by jquery mobile
				that._setOption('title');
				that._validate();
			});

			$section.find("#note-title-autocomplete").accessibleautocomplete({
				"emptyList": autocompleteCallback.emptyList,
				"populateList": autocompleteCallback.populateList,
				"selectItem": autocompleteCallback.selectItem,
				"filterMinLength": 2,
				"filterMaxItems": 50,
				"filterNoItemsMessage": "No Results Found"
			});

			$section.on('accessibleautocompleteafterblur', '#note-title-autocomplete', function( e, input ) {
				var $list = $( this ),
					search = $( input ),
					minLength = $list.accessibleautocomplete("option", "filterMinLength"),
					searchValue = search.val(),
					lastValToPopulate = search.jqmData("lastpopulatedval");

				if( searchValue.length >= minLength && o.title.name !== searchValue ) {
					that._findAndSetTitle(search);
					// _findAndSetTitle() validates in an asynchronous callback
				} else if (o.title.ien === "") {
					that._setOption('title', { name: searchValue });
					that._validate();
				}
			});

			$section.on('tap', '#note-title-autocomplete a', function(e) {
				e.preventDefault();
			});

			// consult popup
			$(document).on('tap', '#note-select-consult li a', function(e) {
				e.preventDefault();
				var index = $(e.currentTarget).closest('li').index() - 1;

				that._setOption('consultIen', o.consultsList[index].consultId);

				$('#note-select-consult').popup('close');
			});

			$(document).on('popupafterclose', '#note-select-consult', function(e) {
				if (o.consultIen === "") {
					that._setOption('title');
					$('#note-title').val(o.title.name);
				}
				that._validate();
			});

			// note body
			$section.on('keyup', '#note-body', function(){
				that._setOption('body', $('#note-section #note-body').val());
				that._validate();
			});
		},
		_findAndSetTitle: function(search){
			var that = this,
				o = this.options,
				searchValue = search.val(),
				titleName = searchValue.trim().toLocaleLowerCase(),
				title;

			o.parentElement.progressNotes('publicGet', this.options.links['note-titles'].href + "?searchstring=" + encodeURIComponent(titleName), function(){
				title = _.find(this.noteTitle, function(title) {
					return title.name.toLocaleLowerCase() === titleName;
				}) || { name: searchValue };

				that._setOption('title', title);
				search.val(title.name);

				if (title.isConsult) {
					that._showConsultPopup(); // validate on popupafterclose
				} else {
					that._validate();
				}
			});
		},
		_autocomplete: function(){
			var that = this,
				o = this.options,
				$section = $(this.element),
				template = this._templates().get(),
				autocompleteDivider = _.template(template.autocompleteDivider),
				autocompleteItem = _.template(template.autocompleteListItem),
				// storing HTML that repeatedly gets prepended to autocomplete
				previousTitleListItems = function() {
					return ( typeof o.previousTitleListItem !== "undefined" && typeof o.previousTitleListItem.ien !== "undefined" ) ? autocompleteDivider({ 'text': 'Previously selected title' }) + autocompleteItem({ 'text': _.escape(o.previousTitleListItem.name), 'alwaysShow': true }) : '';
				},
				emptyList = function(deferred, val, list) {
					list.empty().append(previousTitleListItems());

					return deferred.resolve();
				},
				populateList = function(deferred, val, list) {
					var autocompleteList = "",
						titleName;

					o.parentElement.progressNotes('publicGet', o.links['note-titles'].href + "?searchstring=" + encodeURIComponent(val), function(){
						var numberOfTitles = this.size;

						autocompleteList += autocompleteDivider({ 'text': 'Search Results', 'alwaysShow': true });

						if (numberOfTitles > 0) {
							that._setOption('searchResultsList', this.noteTitle);
							_.each(o.searchResultsList, function(title) {
								autocompleteList += autocompleteItem({ 'text': _.escape(title.name) });
							});
						} else {
							that._setOption('searchResultsList');
						}
						list.empty().append(previousTitleListItems()).append(autocompleteList);

						deferred.resolve();
					});
					return deferred.promise();
				},
				selectItem = function(search, item) {
					var itemIndex = item.index(),
						title;

					if (typeof o.previousTitleListItem.ien !== "undefined") {
						if (itemIndex === 1) {
							title = o.previousTitleListItem;
						} else { // subtract three from index for preceding previous title list item and headers
							title = o.searchResultsList[itemIndex - 3];
						}
					} else { // subtract one from index for "Search Results" header
						title = o.searchResultsList[itemIndex - 1];
					}

					that._setOption('title', title);
					search.val(title.name);

					if (title.isConsult) {
						that._setOption('consultIen');
						that._showConsultPopup(); // validate on popupafterclose
					} else {
						that._validate();
					}
				};
			return {
				emptyList: emptyList,
				populateList: populateList,
				selectItem: selectItem
			};
		},
		_showConsultPopup: function() {
			$('#note-select-consult').popup('open');
		},
		_templates: function(){
			/*jshint multistr: true */
			var o = this.options,
				templates = {
					main: '<label for="note-title" class="ui-input-text">Title <span class="error-message"></span></label> \
							<ul data-role="acccessible-autocomplete" id="note-title-autocomplete" class="autocomplete-list" data-inset="true" data-filter-reveal="true" data-filter-placeholder="Enter Note Title..." ></ul> \
							<label for="note-body" class="ui-input-text">Note</label> \
							<textarea type="text" id="note-body" placeholder="Enter Text Here..." ></textarea> \
							<div data-role="popup" id="note-select-consult" data-overlay-theme="a" data-shadow="true" data-theme="d"> \
								<a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close</a> \
								<ul data-role="listview" data-inset="true" data-icon="false"> \
									<li data-role="list-divider">Select a Consult</li> \
								</ul> \
							</div>',
					consultListItem: '<li><a href="#"><h3><%= title %></h3><p><%= timestamp %> <%= status %></p></a></li>',
					noConsultListItem: '<li><h3><% if ( typeof message !=="undefined") { %><%= message %><% } else { %>No Active, Pending, or Scheduled Consults Found<% } %></h3></li>',
					autocompleteDivider: '<li data-role="list-divider" <% if ( typeof alwaysShow !== "undefined" && alwaysShow ) { %>class="ui-li-unfiltered"<% } %>><%= text %></li>',
					autocompleteListItem: '<li <% if ( typeof alwaysShow !== "undefined" && alwaysShow ) { %>class="ui-li-unfiltered"<% } %>><%= text %></li>'
				};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.encounter", {
		// These options will be used as defaults
		options: {
		},
		_create: function(){
			var o = this.options,
				parentElement = o.parentElement,
				section = this.element,
				template = this._templates().get(),
				content;
			parentElement.progressNotes('registerWidget', this);

			section.html(template.main);
			content = section.find('#encounters-container');
			//' + parentElement.progressNotes('option').clinicalEvent.encounter.locationId
			content.visit({parent: parentElement, link: o.links['visit-types'].href + '?location-ien=' + parentElement.progressNotes('option').clinicalEvent.encounter.locationId});
			content.provider({parent: parentElement, link: o.links['providers'].href, user: o.user});
			content.related({parent: parentElement, link: o.links['visit-related-to'].href + '?location-ien=' + parentElement.progressNotes('option').clinicalEvent.encounter.locationId});
			content.diagnosis({parent: parentElement, link: o.links['diagnoses'].href, problemLink: o.links['problem-list-diagnoses'].href});
			content.procedures({parent: parentElement, link: o.links['procedures'].href, modifiers: o.links['modifiers'].href});

			section.trigger('create');

			// TODO: inserting classes for testing;
			// remove after accessible-autocomplete widget is in, as it will include these classes
			$('#provider-list').wrapAll( $('<div class="ui-listview-wrapper ui-accessible-autocomplete-wrapper ui-scrollable-wrapper"><div class="ui-scrollable"></div></div>') );
			//$('#diagnosis-autocomplete').wrapAll( $('<div class="ui-listview-wrapper ui-accessible-autocomplete-wrapper ui-scrollable-wrapper"><div class="ui-scrollable"></div></div>') );
			//$('#procedures-autocomplete').wrapAll( $('<div class="ui-listview-wrapper ui-accessible-autocomplete-wrapper ui-scrollable-wrapper"><div class="ui-scrollable"></div></div>') );
			$(".ui-listview-filter").addClass("ui-accessible-autocomplete-filter ui-accessible-autocomplete-filter-inset");
			$(".ui-listview:jqmData(filter='true')").addClass("ui-accessible-autocomplete ui-accessible-autocomplete-inset");
		},
		_setOption: function(key, value){
			switch(key){
				case "#":

					break;

			}
		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			$('#encounters-container').visit('destroy');
			$('#encounters-container').provider('destroy');
			$('#encounters-container').related('destroy');
			$('#encounters-container').procedures('destroy');
			$('#encounters-container').diagnosis('destroy');
			$('#encounters-container').empty();
		},
		_delegateEvents: function(){
		},
		_templates: function(){
			/*jshint multistr: true */
			templates = {
				main: '<div id="encounters-container" data-role="collapsible-set" data-mini="true" data-theme="b" data-content-theme="c" data-collapsed="false" data-iconpos="right"></div>'
			};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.visit", {
		// These options will be used as defaults
		options: {
			defaults: {
				visitTypes: [],
				selectedVisitType: {}
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var that = this,
				o = this.options,
				section = this.element,
				template = this._templates().get(),
				mainTemplate = $(template.main),
				visitTemplate = _.template(template.visitItem),
				visitSectionTemplate = _.template(template.sectionItem),
				noDataTemplate = _.template(template.noData),
				visitTypeSet = mainTemplate.find('fieldset').eq(0),
				visitSectionSet = mainTemplate.find('fieldset').eq(1),
				fullList = '',
				sectionsList = '';

			o.parent.progressNotes('registerWidget', this);
			this._resume();
			section.append(mainTemplate);

			// if statement in case note is being resumed
			if (typeof o.visitTypes === "undefined" || o.visitTypes.length === 0) {
				o.parent.progressNotes('publicGet', o.link, function() {
					var sections,
						modifiers;
					if(typeof this.visitType !== "undefined") {
						o.visitTypes = this.visitType;
					}

					if(o.visitTypes.length > 0){
						_.each(o.visitTypes, function(type) {
							sections = type.sections;

							type.selected = false;
							fullList += visitTemplate(type);

							_.each(sections, function(section) {
								modifiers = section.modifiers;

								section.selected = false;

								_.each(modifiers, function(modifier) {
									modifier.selected = false;
								});
							});
						});
					} else {
						o.visitTypes = [];
						fullList += noDataTemplate();
					}
					visitTypeSet.find(".ui-loading").remove();
					section.find("#visit-section").append(sectionsList);
					visitTypeSet.append(fullList).trigger('create');
					that._validate();
					that._delegateEvents();

				}, function() {
					o.visitTypes = [];
					fullList += noDataTemplate({ message: $.parseJSON(this.responseText).message });

					visitTypeSet.find(".ui-loading").remove();
					section.find("#visit-section").append(sectionsList);
					visitTypeSet.append(fullList).trigger('create');
					that._validate();
					that._delegateEvents();
				});
			}else{
				var hasSelection = false,
					sections = [];
				_.each(o.visitTypes, function(type) {

					if(type.selected)
					{
						o.selectedVisitType = type;
						sections = type.sections;
						hasSelection = true;
					}

					fullList += visitTemplate(type);

				});
				if(hasSelection)
				{
					sectionsList = that._drawSectionList(sections);
				}
				visitTypeSet.find(".ui-loading").remove();
				section.find("#visit-section").append(sectionsList);
				visitTypeSet.append(fullList).trigger('create');
				that._validate();
				that._delegateEvents();
			}

		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			var $document = $(document);

			$document.off('click tap', '#visit-section-modifiers .ui-checkbox');
			$document.off('tap', '#visit-section-modifiers button');
			$document.off('keydown', '#visit-section-modifiers button');
			$document.off('popupafterclose', '#visit-section-modifiers');

			$('#visit-section-modifiers').popup('destroy');
			$('#visit-section-modifiers').remove();
		},

		_drawSectionList: function(sections) {
			var o = this.options,
				item = null,
				template = this._templates().get(),
				sectionHeader = template.sectionHeader,
				sectionItemTemplate = _.template(template.sectionItem),
				fullList = '',
				fullSection = sectionHeader;

			_.each(sections, function(section) {
				if(typeof section.selected === "undefined"){
					section.selected = false;
				}
				fullList += sectionItemTemplate(section);
			});
			fullSection += fullList;
			return fullSection;

		},
		_drawVisitType: function( isLoadingSection ){
			var o = this.options,
				that = this,
				section = this.element,
				template = this._templates().get(),
				mainTemplate = $(template.main),
				visitTemplate = _.template(template.visitItem),
				visitSectionTemplate = _.template(template.sectionItem),
				noDataTemplate = _.template(template.noData),
				visitTypeSet = mainTemplate.find('fieldset').eq(0),
				visitSectionSet = mainTemplate.find('fieldset').eq(1),
				fullList = '';

			_.each(o.visitTypes, function(type) {
				sections = type.sections;

				type.selected = false;
				fullList += visitTemplate(type);

				_.each(sections, function(section) {
					modifiers = section.modifiers;

					section.selected = false;

					_.each(modifiers, function(modifier) {
						modifier.selected = false;
					});
				});
			});
			o.visitTypes = [];
			fullList += noDataTemplate();

			visitTypeSet.append(fullList).trigger('create');
		},
		_setOption: function(key, value){
			var that = this,
				o = that.options;
			val = value;


			switch(key){
				case 'resumeVisit':
					o.visitTypes = value;
					break;
				case 'visit':
					value.selected = true;
					/*this.options.selectedVisitType = value;
					_.each(this.options.visitTypes, function(node, i){
						node.selected = false;
					});
					this.options.selectedVisitType.selected = true;*/
					break;
				case 'section':
					var types = o.visitTypes;

					_.each(types, function(item){
						if(item.selected === true){
							_.each(item.sections, function(node){
								node.selected = false;
							});
							item.sections[val].selected = true;
						}
					});


					break;
				case 'modifier':
					types = o.visitTypes;

					_.each(types, function(item){
						if(item.selected === true){
							_.each(item.sections, function(node){
								if(node.selected === true){
									node.modifiers[val].selected = !node.modifiers[val].selected;
								}
							});

						}
					});
					/*var sections = o.selectedVisitType.sections,
						section = _.find(sections, function(section) {
							return section.selected;
						}),
						selectedModifiers = [];
						modifier = section.modifiers[value];

					modifier.selected = !(modifier.selected);
					_.each(section.modifiers, function(modifier) {
						if (modifier.selected) {
							selectedModifiers.push(modifier);
						}
					})
					section.selectedModifiers = selectedModifiers;*/
					break;
			}
		},
		_resume: function(){
			var resumeData = this.options.parent.progressNotes('getVisit'),
				visitData = resumeData.object,
				isDraft = resumeData.isDraft;
			if (typeof visitData !== "undefined" && visitData.length > 0 ) {
				this._setOption('resumeVisit', visitData);
			}
		},
		_validate: function(pass){
			//Only pass needed is on visit type selection
			var o = this.options;

			if (o.visitTypes.length === 0 ) {
				this.element.trigger(this.widgetEventPrefix, {pass: true});
			} else if (o.visitTypes.length > 0 ) {
				var valid = false;

				_.each(o.visitTypes, function(item) {
					_.each(item.sections,function(section) {
						if(section.selected === true) {
							valid = true;
						}
					});
				});

				this.element.trigger(this.widgetEventPrefix, {pass: valid});

			} else {
				this.element.trigger(this.widgetEventPrefix, {pass: false});
			}
		},
		_delegateEvents: function(){
			var that = this,
				o = this.options,
				$document = $(document);
			this.element.on('change', '.visit-type-section fieldset:first-of-type .ui-radio input', function() {
				o.selectedVisitType = o.visitTypes[$(this).index() - 1];
				that._createSectionList($(this).index() - 1);
				that._validate();
				$(this).focus();
			});
			this.element.on('change', '.visit-type-section fieldset:nth-of-type(2) .ui-radio input', function(e){
				var wrapper = $(this).closest('div.relative-wrapper'),
					container = wrapper.parent(),
					index = wrapper.index();
				that._setOption('section', index - 1);
				that._createSectionList();
				that._validate();
				$(container.find(".ui-radio")[index]).find("input").focus();
			});
			this.element.on('tap', '.visit-type-section fieldset:nth-of-type(2) button', function(e){
				return modifiersPopupButtonHandler(e);
			});

			this.element.on('keydown', '.visit-type-section fieldset:nth-of-type(2) button', function(e){
				if(e.which === 13){
					return modifiersPopupButtonHandler(e);
				}
			});


			var modifiersPopupButtonHandler = function(e){
				var wrapper = $(e.currentTarget).closest('div.relative-wrapper'),
					sectionIndex = wrapper.index() - 1;
				that._setOption('section', sectionIndex);
				wrapper.find('input').prop("checked", true);
				$('.visit-type-section fieldset:nth-of-type(2) input').checkboxradio("refresh");
				// create and open popup of modifier list
				that._createModifierList(sectionIndex);
			};

			//TODO: figure out the best way to handle this event
			//var modifiersPopupEscapeHandler = function(e){
			//	if(e.which === 27){
			//		$('#visit-section-modifiers').popup('close');
			//		e.preventDefault();
			//		return false;
			//	}
			//};

			//$("#visit-section-modifiers").on("keyup", function(e){
			//	return modifiersPopupEscapeHandler(e);
			//});

			//$("#visit-section-modifiers-popup").on("keyup", function(e){
			//	return modifiersPopupEscapeHandler(e);
			//});

			//$("#visit-section-modifiers-screen").on("keyup", function(e){ //may not be a necessary handler, not sure if screen can ever get focus
			//	return modifiersPopupEscapeHandler(e);
			//});

			$document.on('click tap', '#visit-section-modifiers .ui-checkbox', function(){
				that._setOption('modifier', $(this).index() - 1);
			});

			$document.on('tap', '#visit-section-modifiers button', function(){
				$('#visit-section-modifiers').popup('close');
			});

			$document.on('keydown', '#visit-section-modifiers button', function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					$('#visit-section-modifiers').popup('close');
				}
			});

			$document.on('popupafterclose', '#visit-section-modifiers', function( event, ui ) {
				that._createSectionList();
				that._validate();

				//give focus to the button that was clicked after the closing the modifiers popup to enable continued keyboard navigation
				$("input[name=visitSection]:checked").closest(".relative-wrapper").find("button").focus();
			});
		},
		_createSectionList: function(typeIndex) {
			var o = this.options,
				item = null,
				template = this._templates().get(),
				sectionHeader = _.template(template.sectionHeader)(),
				sectionItemTemplate = _.template(template.sectionItem),
				fullList = '';

			if (typeof typeIndex !== "undefined") {
				item = o.visitTypes[typeIndex];
				this._setOption('visit', item);
			} else {
				item = o.selectedVisitType;
			}

			_.each(item.sections, function(section) {
				fullList += sectionItemTemplate(section);
			});

			$("#visit-section").empty().append(fullList).prepend(sectionHeader);
			$("#visit-section").trigger('create');
		},
		_createModifierList: function(sectionIndex) {
			var template = this._templates().get(),
				$container = $('#visit-section-modifiers'),
				$modifiersPopupContent = $container.find('[data-role="content"]'),
				$listContainer = $(template.modifiers),
				modifierItem = _.template(template.modifierItem),
				fullList = "",
				modifiers = "",
				types = this.options.visitTypes;

			_.each(types, function(item){
				if(item.selected === true){
					modifiers = item.sections[sectionIndex].modifiers;
				}
			});
			if (modifiers.length !== 0) {
				_.each(modifiers, function(modifier){
					fullList += modifierItem(modifier);
				});
			} else {
				fullList = _.template(template.noModifiersHeader)();
			}

			$container.find('fieldset').empty().append(fullList);
			$container.trigger('create').popup('open');
			$modifiersPopupContent.css({"max-height": $(window).height() - 100});
		},
		_templates: function(){
			/*jshint multistr: true */
			var o = this.options,
			templates = {
				main: '<div data-role="collapsible" class="inset-select-list visit-type-section"> \
							<h3>Visit Type</h3> \
							<div class="content">\
								<fieldset data-role="controlgroup" class="group-vertical-input"> \
									<div role="heading" class="ui-li ui-li-divider ui-bar-d ui-li-has-count"> \
										<legend>Type Of Visit</legend> \
									</div> \
									<div class="ui-loading"><h3>Loading</h3><span class="ui-sending"></span></div> \
								</fieldset> \
								<fieldset id="visit-section" data-role="controlgroup" class="group-vertical-input"></fieldset> \
							</div> \
							<div data-role="popup" id="visit-section-modifiers" data-overlay-theme="a" data-shadow="true" data-theme="d"> \
								<a href="#" data-rel="back" data-role="button" data-theme="b" data-icon="delete" data-iconpos="notext" title="close" class="ui-btn-close ui-btn-right ui-btn ui-shadow ui-btn-icon-notext ui-btn-up-b"><span class="ui-btn-inner"><span class="ui-btn-text">Close</span><span class="ui-icon ui-icon-delete ui-icon-shadow">&nbsp;</span></span></a> \
								<div data-role="header" data-theme="b" class="ui-header ui-bar-b"> \
									<h3 role="heading" aria-level="1" class="ui-title">Modifiers</h3> \
								</div> \
								<div data-role="content"> \
									<fieldset data-role="controlgroup" class="group-vertical-input"></fieldset> \
								</div> \
								<button data-mini="true" data-theme="b">Done</button> \
							</div> \
						</div>',
				noData: '<label for="noVisitType" data-iconpos="right"> \
								<span type="text" id="noVisitType" class="ui-btn-inner" name="visitType"><% if (typeof message === "undefined") { %>Clinic has not provided Visit Types<% } else { %><%= message %><% }%></span> \
							</label>',
				visitItem: '<label for="<%= name %>IsVisitType" data-iconpos="right"> \
								<input type="radio" id="<%= name %>IsVisitType" name="visitType" <% if (selected) { %> checked="checked" <% } %> /> \
								<%= name %> \
							</label>',
				sectionHeader: '<div role="heading" class="ui-li ui-li-divider ui-bar-d ui-li-has-count">Section <span class="ui-li-count ui-btn-up-c">Modifiers</span></div>',
				sectionItem: '<div class="relative-wrapper"> \
								<label for="<%= description %>IsVisitSection" data-iconpos="right"> \
									<input type="radio" id="<%= description %>IsVisitSection" name="visitSection" <% if (selected) { %> checked="checked" <% } %> /> \
									<%= description %> \
									<% if(selected){ %><ul class="modifiers-list"><% for(var i=0; i < modifiers.length; i++){ if(modifiers[i].selected){ %><li class="ui-li-desc"><%= modifiers[i].name %></li><% } } %></ul><% } %> \
								</label> \
								<button data-icon="grid" data-iconpos="notext"/> \
							</div>',
				noModifiersHeader: '<h3 role="heading" style="max-width:100%;">No Modifiers Found</h3>',
				modifierItem: '<label for="<%= name %>IsVisitSectionModifier" data-iconpos="right"> \
								<input type="checkbox" id="<%= name %>IsVisitSectionModifier" name="visitSectionModifier" <% if (selected) { %> checked="checked" <% } %>  /> \
								<%= name %> \
							</label>'
				};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.provider", {
		// These options will be used as defaults
		options: {
			defaults: {
				autocompleteProviders: []
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var	that = this,
				o = this.options,
				section = that.element,
				template = that._templates().get(),
				mainTemplate = $(template.main),
				providerTemplate = _.template(template.providersItem),
				leftColContainer = $(template.available),
				availableHeader = _.template(template.availableHeader)(),
				list = $(leftColContainer);

			o.parent.progressNotes('registerWidget', this);
			this._resume();
			// if statement in case note is being resumed

			for (var i = o.providers.length - 1; i >= 0; i--) {
				list.prepend(providerTemplate(o.providers[i]));
			}

			list.prepend(availableHeader);
			section.append(mainTemplate);
			mainTemplate.find('.content').append(leftColContainer).trigger('create');
			that._delegateEvents();

			section.trigger(this.widgetEventPrefix, {pass: true});
		},
		destroy: function() {
			delete this.options;
			this._super();
		},
		_resume: function(){
			var resumeData = this.options.parent.progressNotes('getProviders'),
				resumedProviders = resumeData.object,
				isDraft = resumeData.isDraft;
			this._setOption('providers', resumedProviders);

		},
		_createProviderAutocomplete: function() {
			var that = this,
				o = this.options,
				addedProviders = o.providers,
				template = this._templates().get(),
				list = $('#provider-list'),
				listItem = _.template(template.autocompleteListItem),
				errorItem = _.template(template.autocompleteErrorItem),
				providerInputText = $('.provider-section .ui-listview-filter input').val().toLowerCase(),
				searchResults = '';
			o.parent.progressNotes('publicGet', o.link + "?searchstring=" + providerInputText, function(){
				var autocompletelist = $('#provider-list'),
					autocompleteHeight = $('body').outerHeight() - $('#footer').outerHeight() - $('.provider-section .ui-listview-filter .ui-input-search').offset().top - $('.provider-section .ui-listview-filter .ui-input-search').outerHeight() - parseInt(autocompletelist.css('margin-bottom'), 10);

				autocompletelist.css({"max-height":autocompleteHeight});

				if(this.size > 0) {
					var currProvider,
						addedProvider;

					o.autocompleteProviders = _.filter(this.facilityProvider, function(currProvider) {
						addedProvider = _.find(addedProviders, function(providerItem){
							return providerItem.facilityProvider.providerIen === currProvider.providerIen;
						});

						if (typeof addedProvider === "undefined") {
							searchResults += listItem( currProvider );
							return true;
						}
					});

					if (o.autocompleteProviders.length === 0) {
						searchResults += errorItem();
					}
				} else {
					searchResults += errorItem();
				}
				list.empty().append(searchResults);
				list.listview('refresh').show();
			});
		},
		_setOption: function(key, value){
			var o = this.options;

			switch(key){
				case 'providers':
					o.providers = value;
					break;
			}
		},
		_validate: function(){
			var iterator = function(providerItem) {
					return (providerItem.primary === true && providerItem.selected === true);
				};

			//this.element.trigger(this.widgetEventPrefix);
			if (typeof _.find(this.options.providers, iterator) === "undefined") {
				this.element.trigger(this.widgetEventPrefix, {pass: false});
			} else {
				// providers already in this.options.providers
				this.element.trigger(this.widgetEventPrefix, {pass: true});
			}
		},
		_selectFromAutocompleteList: function(e){

			var o = this.options,
				providerText = $(e.currentTarget).text(),
				currentProviderIndex = $(e.currentTarget).closest('li').index();

			$('.provider-section .ui-listview-filter input').val(providerText);
			this._insertSelected(o.autocompleteProviders[currentProviderIndex]);
			this._hideAutocompleteList();

		},
		_hideAutocompleteList: function(){
			this.options.autocompleteProviders = [];
			$('#provider-list').empty();
			$('#provider-list').css("display", "none");
		},
		_insertSelected: function(selectedProvider, isPrimary){
			var o = this.options,
				that = this,
				template = that._templates().get(),
				providerTemplate = _.template(template.providersItem),
				providerHeader = _.template(template.availableHeader)(),
				leftColContainer = $(template.available),
				list = $(leftColContainer),
				fullList = '',
				newProvider = {
					primary: (typeof isPrimary === "undefined") ? false : isPrimary,
					facilityProvider: selectedProvider,
					selected: true
				},
				newProviderName = newProvider.facilityProvider.providerName;
			var currProviderName = o.providers[o.providers.length - 1].facilityProvider.providerName;
			var compare = newProviderName.localeCompare(currProviderName),
				isAlreadyListed = false;

			// maintain alphabetical order
			if (compare > 0) {
				o.providers.push(newProvider);
			} else if (compare < 0) {
				var i;
				for(i = o.providers.length - 2; i >= 0; i--) {
					currProviderName = o.providers[i].facilityProvider.providerName;
					compare = newProviderName.localeCompare(currProviderName);
					if (compare > 0) {
						o.providers.splice(i + 1, 0, newProvider);
						break;
					} else if (compare === 0) {
						isAlreadyListed = true;
						break;
					}
				}

				if (i === -1) {
					// only reaches here if it goes in front of list
					o.providers.unshift(newProvider);
				}
			} else {
				isAlreadyListed = true;
			}

			if (!isAlreadyListed) {
				_.each(o.providers, function(node){
					fullList += providerTemplate(node);
				});
				$('#providers-available').empty().append(fullList).prepend(providerHeader).trigger('create').controlgroup('refresh');
				this._validate();
			}
		},
		_moveUp: function(e){
			e.preventDefault();
			var elementList = $(e.currentTarget).closest('li').prevAll(":visible").not('[data-role = "list-divider"]'),
				topOfList = false;
			if(elementList.length === 0){
				elementList = $(e.currentTarget).closest('li').nextAll(":visible").not('[data-role = "list-divider"]');
				topOfList = true;
			}
			if(elementList.length > 0 && topOfList)
				$(elementList[elementList.length-1]).find('a').focus();

			else if(elementList.length > 0 && !topOfList)
				$(elementList[0]).find('a').focus();

			else{
				$('.provider-section .ui-listview-filter input').focus();
			}
		},
		_moveDown: function(e){
			e.preventDefault();
			var elementList = $(e.currentTarget).closest('li').nextAll(":visible").not('[data-role = "list-divider"]'),
				bottomOfList = false;
			if(elementList.length === 0){
				elementList = $(e.currentTarget).closest('li').prevAll(":visible").not('[data-role = "list-divider"]');
				bottomOfList = true;
			}

			if(elementList.length > 0 && bottomOfList)
				$(elementList[elementList.length-1]).find('a').focus();

			else if(elementList.length > 0 && !bottomOfList)
				$(elementList[0]).find('a').focus();

			else{
				$('.provider-section .ui-listview-filter input').focus();
			}

		},
		_delegateEvents: function(){
			var that = this,
				o = this.options;

			this.element.on('click tap', '#providers-available .ui-checkbox', function() {
				var index = $(this).closest('div.relative-wrapper').index() - 1,
					node = o.providers[index];

				node.selected = !node.selected;

				if(node.primary === true) {
					node.primary = false;
					that._selectPrimary();
					//that._validate() called in _selectPrimary()
					return false;
				} // else allow default action to update appearance
				that._validate();
			});
			this.element.on('click tap', '#providers-available .ui-radio',function(e) {
				var index = $(this).closest('div.relative-wrapper').index() - 1;

				that._selectPrimary(index); //select primary should be reworked to only udpate the elements as necessary, not recreate the list
				$($('#providers-available .relative-wrapper')[index]).find('.ui-radio input').focus(); //this can be reworked once the above is complete
				e.preventDefault();
				return false;
				//that._validate() called in _selectPrimary()
			});
			this.element.on('keyup', '.provider-section .ui-listview-filter input', function(e){
				var key = e.which,
					autocompleteText = $('.provider-section .ui-listview-filter input').val();

				switch(key){
					case 27: //Escape
						if($('#provider-list').is(":visible")){
							e.preventDefault();
							that._hideAutocompleteList();
							return false;
						}
						break;
					default:
						var autocomplete = $('#provider-list');

						if(autocompleteText.length >= 2){
							that._createProviderAutocomplete();
						}else{
							autocomplete.hide();
						}
						break;
				}
			});

			this.element.on('keydown', '.provider-section .ui-listview-filter input', function(e){
				var key = e.which,
					autocompleteText = $('.provider-section .ui-listview-filter input').val();

				switch(key){
					case 38: //up aarow
						if($('#provider-list').is(":visible")){
							e.currentTarget.blur();

							var autocompleteList = $('#provider-list li:visible').not('[data-role = "list-divider"]');

							autocompleteList.eq(autocompleteList.length-1).find('a').focus();
						}
						break;
					case 40: //down aarow
						if($('#provider-list').is(":visible")){
							$('#provider-list li:visible').not('[data-role = "list-divider"]').eq(0).find('a').focus();
						}
						break;
				}
			});

			this.element.on('tap', '.provider-section .ui-listview-filter .ui-input-clear', function(){
				that._hideAutocompleteList();
			});
			this.element.on('tap', '#provider-list a', function(e){
				e.preventDefault();
				$('.provider-section .ui-listview-filter input').val(e.currentTarget.text);
				that._selectFromAutocompleteList(e);
				$('#provider-list').hide();
			});
			this.element.on('focus', '.provider-section .ui-listview-filter input', function(e){
				var listItems = $('#provider-list');

				if(listItems.find('li').length > 0 && $('.provider-section .ui-listview-filter input').val() !== "")
				{
					listItems.show();
				}
			});
			this.element.on('keyup', '#provider-list li a', function(e){
				var key = e.which;
				switch(key){
					case 27: //Escape
						$('.provider-section .ui-listview-filter input').focus();
						that._hideAutocompleteList();
						break;
				}
			});
			this.element.on('keydown', '#provider-list li a', function(e){
				var key = e.which;
				switch(key){
					case 13: //Enter
						e.preventDefault();
						if(!$(e.currentTarget).closest('li').hasClass('always-show'))
						{
							that._selectFromAutocompleteList(e);
						}
						break;
					case 32: //Space Bar
						e.preventDefault();
						if(!$(e.currentTarget).closest('li').hasClass('always-show'))
						{
							that._selectFromAutocompleteList(e);
						}
						break;
					case 38: //up aarow
						that._moveUp(e);
						break;
					case 40: //down aarow
						that._moveDown(e);
						break;
				}
			});
		},
		_selectPrimary: function(index) {
			var o = this.options,
				userId = o.user.id,
				primaryNode,
				currentUserNode,

				template = this._templates().get(),
				providerTemplate = _.template(template.providersItem),
				providerHeader = _.template(template.availableHeader)(),
				fullList = '';

			_.each(o.providers, function(node){
				if (node.facilityProvider.providerIen === userId) {
					currentUserNode = node;
				}
				node.primary = false;
			});

			if (typeof index !== "undefined" && index >= 0) {
				primaryNode = o.providers[index];
			} else {
				primaryNode = currentUserNode;

				var currentProviderIndex = _.indexBy(this.options.providers, function(node) {
					return node.selected === true;
				});
				if (currentProviderIndex >= 0) {
					primaryNode = o.providers[currentProviderIndex];
				}
			}

			primaryNode.primary = true;
			primaryNode.selected = true;

			this._validate();

			_.each(o.providers, function(node){
				fullList += providerTemplate(node);
			});
			$('#providers-available').empty().append(fullList).prepend(providerHeader).trigger('create').controlgroup('refresh');
		},
		_templates: function(){
			/*jshint multistr: true */
			var o = this.options,
			templates = {
				main: '<div data-role="collapsible" class="inset-select-list provider-section"> \
							<h3>Providers</h3>\
							<div id="provider-section" class="content progress-note-collapsible"> \
								<div class="progress-note-collapsible-padding"> \
									<ul id="provider-list" class="autocomplete-list" data-role="listview" data-filter="true" data-inset="true" data-filter-placeholder="Other provider..." ></ul> \
								</div> \
							</div> \
						</div>',
				autocompleteListItem: '<li data-icon="false"><a href="#"><%= providerName %></a></li>',
				autocompleteErrorItem: '<li data-role="list-divider" data-icon="false">No Providers Found</li>',
				available: '<fieldset id="providers-available" data-role="controlgroup" class="group-vertical-input"></fieldset>',
				availableHeader: '<div role="heading" class="ui-li ui-li-divider ui-bar-d ui-li-has-count">Available <span class="ui-li-count ui-btn-up-c ui-corner-all">Primary</span></div>',
				providersItem: '<div class="relative-wrapper"> \
							<label for="<%= facilityProvider.providerIen %>IsPrimaryProvider" data-iconpos="notext"> \
								<input type="radio" id="<%= facilityProvider.providerIen %>IsPrimaryProvider" name="encounterPrimaryProvider" <% if (primary) { %> checked="checked" <% } %> /> \
								<%= facilityProvider.providerName %> is Primary Provider \
							</label> \
							<label for="<%= facilityProvider.providerIen %>IsProvider" data-iconpos="right"> \
								<input type="checkbox" id="<%= facilityProvider.providerIen %>IsProvider" name="encounterProviders" <% if (selected) { %> checked="checked" <% } %> /> \
								<%= facilityProvider.providerName %> \
							</label> \
						</div>'
				};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.related", {
		// These options will be used as defaults
		options: {
			defaults: {
				visitRelatedTos: []
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var that = this,
				o = this.options,
				section = this.element,
				template = this._templates().get();

			o.parent.progressNotes('registerWidget', this);
			section.append(template.main);

			this._resume();
			if (o.visitRelatedTos.length === 0) {
				// retrieve
				o.parent.progressNotes('publicGet', o.link, function(){
					o.visitRelatedTos = this.visitRelatedTo;
					that._drawListItems();

					that._validate();
				}, function() {
					that._drawErrorMessage( $.parseJSON(this.responseText).message );
					that._validate();
				});
			}
			this._delegateEvents();
		},
		destroy: function() {
			delete this.options;
			this._super();
		},
		_resume: function(){
			var o = this.options;

			this._setOption("relatedTo", o.parent.progressNotes('getRelatedInfo'));
			if (o.visitRelatedTos.length > 0) {
				this._validate();
				this._drawListItems();
			}
		},
		_setOption: function(key, value){
			var that = this,
				o = this.options;
			if(key === "relatedTo")
			{
				o.visitRelatedTos = value;
			}
			else{
				var item;
				if (typeof value.item !== "undefined" ){
					item = value.item;
				} else if (typeof value.index !=="undefined" ) {
					item = this.options.visitRelatedTos[value.index];
				}

				if (typeof item.enabled === "undefined" || item.enabled) {
					switch(key){
						case "true":
							item.checked = true;
							break;
						case "false":
							item.checked = false;
							break;
					}
				}
			}
		},
		_validate: function(){
			var relatedList = this.options.visitRelatedTos,
				pass = false;
			if ( relatedList.length > 0) {
				pass = _.every(relatedList, function(relatedItem) {
					return !relatedItem.enabled || typeof relatedItem.checked !== "undefined";
				});
			}
			this.element.trigger(this.widgetEventPrefix, {pass: pass});
		},
		_delegateEvents: function(){
			var that = this;
			// change only fires for clicked radio button
			this.element.on('change', '.related-to-section input[type=radio]', function() {
				var index = $(this).closest('fieldset').index(),
					value = $(this).val();
				that._setOption(value, {index: index});
				that._validate();
			});
		},
		_drawListItems: function( errorMessage ) {
			var relatedList = this.options.visitRelatedTos,
				relatedItem,
				length = relatedList.length,
				preRenderedList = '',
				template = this._templates().get(),
				itemTemplate = _.template(template.listItem),
				section = $('.related-to-section');

				if (length > 0) {
					for (var i = 0; i < length; i++) {
						relatedItem = relatedList[i];
						preRenderedList += itemTemplate($.extend(relatedItem, {index: i}));
					}

					section.empty().append(preRenderedList).trigger("create");
				} else {
					this._drawErrorMessage( errorMessage );
				}
		},
		_drawErrorMessage: function( message ) {
			var preRenderedList = '',
				template = this._templates().get(),
				errorMessageTemplate = _.template(template.errorMessage),
				section = $('.related-to-section');

				preRenderedList = errorMessageTemplate({ message: message });

				section.empty().append(preRenderedList).trigger("create");
		},
		_templates: function(){
			/*jshint multistr: true */
			templates = {
				main: '<div data-role="collapsible"> \
								<h3>Related To</h3> \
								<div class="related-to-section">\
									<div class="ui-loading"><h3>Loading</h3><span class="ui-sending"></span></div> \
								</div> \
							</div>',
				listItem: '<div data-role="fieldcontain"> \
								<fieldset data-role="controlgroup" data-type="horizontal" data-mini="true"> \
									<legend><%= title %></legend> \
									<input type="radio" name="<%= _.escape(title.replace(/\\s/g, "-")) %>" id="related-to-<%= index %>-yes" value="true" <% if (typeof checked !== "undefined" && checked) { %> checked="checked" <% } %> <% if (typeof enabled !== "undefined" && !enabled) { %> disabled <% } %> /> \
									<label for="related-to-<%= index %>-yes">Yes</label>  \
									<input type="radio" name="<%= _.escape(title.replace(/\\s/g, "-")) %>" id="related-to-<%= index %>-no" value="false" <% if (typeof checked !== "undefined" && !checked) { %> checked="checked" <% } %> <% if (typeof enabled !== "undefined" && !enabled) { %> disabled <% } %> /> \
									<label for="related-to-<%= index %>-no">No</label>  \
								</fieldset> \
							</div>',
				errorMessage: '<span><%= message %></span>'
			};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.procedures", {
		// These options will be used as defaults
		options: {
			defaults: {
				"autocompleteList" : [],
				"uniqueAutocompleteList" : [],
				"selectedProcedures" : [],
				"procedureBeingModified" :{}
			}
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var o = this.options,
				section = this.element,
				template = this._templates().get();


			section.append(template.main);

			$('#procedures-section').append(template.proceduresListContainer).append(template.proceduresPopup).append(template.modifiersPopup);
			$('#procedures-section').trigger('create');
			$('#procedures-popup').popup();
			$('#procedure-modifiers').popup();
			o.parent.progressNotes('registerWidget', this);

			this._resume();
			this._toggleButtons();
			this._delegateEvents();
		},
		_resume: function(){

			var that = this,
				o = this.options,
				resumeInfo = o.parent.progressNotes('getProceduresInfo'),
				procedureCodes = resumeInfo.object;
			if(typeof procedureCodes === "undefined")
			{
					procedureCodes = [];
			}
			this._setOption("procedures", procedureCodes);
			if (o.selectedProcedures.length > 0) {
				this._drawSelectedProcedures();
			}
		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			var $document = $(document);

			$document.off('tap click', '#procedure-modifiers .ui-checkbox');
			$document.off('tap', '#procedure button');
			$document.off('popupafterclose', '#procedure-modifiers');

			$('#procedures-popup').popup('destroy');
			$('#procedures-popup').remove();

			$('#procedures-popup').off('popupbeforeposition');
			$('#procedures-popup').off('tap keydown', 'a[title="close"]');
			$('#procedures-popup').off('tap keydown', '.procedures-section-autocomplete a.ui-input-clear');
			$('#procedures-popup').off('keyup', '.procedures-section-autocomplete input');
			$('#procedures-popup').off('keydown', '#procedures-autocomplete li a');
			$('#procedures-popup').off('tap', '#procedures-autocomplete li a');

			$('#procedure-modifiers').popup('destroy');
			$('#procedure-modifiers').remove();
		},
		_setOption: function(key, value){
			var o = this.options,
				that = this;

			switch(key){
				case "procedures":
					_.each(value, function(item){
						if (typeof item.modifiers === "undefined" || item.modifiers === ""){
							item.modifiers = [];
						} else {
							_.each(item.modifiers,function(modifier){
								modifier.selected = true;
							});
						}
						item.selectedModifiers = item.modifiers;
						item.modifiers = [];
					});
					o.selectedProcedures = value;
					break;
				case "autocompleteList":
					o.autocompleteList = value;
					break;
				case "uniqueAutocompleteList":
					o.uniqueAutocompleteList = value;
					break;
				case "selectedProcedures":
					_.each(value.modifiers, function(item){
						if(typeof  item.selected === "undefined") {
							item.selected = false;
						}
					});
					value.selectedProcedure.modifiers = value.modifiers;
					o.selectedProcedures.push(value.selectedProcedure);
					break;
				case "selectedProcedureModifiers":
					// selectedProcedure from o.selectedProcedures assumed to be passed in
					_.each(value.modifiers, function(item){
						if(typeof item.selected === "undefined") {
							item.selected = false;
						}
					});
					value.selectedProcedure.modifiers = value.modifiers;
					break;
				case "addModifiers":
					var modifiers;
					_.find(o.selectedProcedures,function(item){
						if(String(item.ien) === String(value.procedureId) && String(item.code) === String(value.procedureCode)){
							modifiers = value.modifiers;
							item.selectedModifiers = _.filter(modifiers, function(modifier) {
								return modifier.selected;
							});
							return true;
						}
					});
					break;
				case "setCurrentProcedure":
					o.procedureBeingModified = value;
					_.find(o.selectedProcedures,function(item){
						if ( String(item.ien) === String(value.procedureId) && String(item.code) === String(value.procedureCode) ){
							o.procedureBeingModified.modifiers = item.modifiers;
							return true;
						}
					});
					break;
				case "updateModifier":
					_.find(o.procedureBeingModified.modifiers,function(item){
						if ( String(item.ien) === String(value.ien) && String(item.code) === String(value.code) ){
							item.selected = !item.selected;
							that._setOption('addModifiers',{'procedureId': o.procedureBeingModified.procedureId , 'procedureCode': o.procedureBeingModified.procedureCode , 'modifiers':o.procedureBeingModified.modifiers });
							return true;
						}
					});
					/*
					var currentModifier = o.procedureBeingModified.modifiers[value.index];
					currentModifier.selected = !currentModifier.selected;
					that._setOption('addModifiers',{'procedureId': o.procedureBeingModified.procedureId , 'procedureCode': o.procedureBeingModified.procedureCode , 'modifiers':o.procedureBeingModified.modifiers });
					*/
					break;
				case "removeSelectedProcedure":
					var selectedList = that.options.selectedProcedures,
						count = _.indexBy(selectedList, function(item) {
							return (String(item.ien) === String(value.ien) && String(value.code) === String(value.code));
						});

					selectedList.splice(count,1);
					break;
			}
		},
		_validate: function(){
			// if length of selected procedures is > 0, pass: true;
			// else pass: false
			var proceduresAvailible = this.options.selectedProcedures.length > 0;

			this.element.trigger(this.widgetEventPrefix, {
				pass: (proceduresAvailible)
			});
		},
		_delegateEvents: function(){
			var that = this,
				page = that.options.parent.progressNotes('option', 'page'),
				o = this.options,
				cssResize = function(selector) {
					var $selector = $(selector),
						$page = $(page),
						width = Math.round($page.innerWidth()) - 4,
						height = Math.round($page.innerHeight()) - 14;

					$selector.css({
						'max-width': width + 'px',
						'width': width + 'px',
						'height': height + 'px'
					});
					$(selector + ' [data-role="content"]').css({'height': height - 39 + 'px' });
				};

			$('#procedures-popup').on( "popupbeforeposition", function( event, ui, options ) {
				$('#procedures-popup').popup( 'option', 'positionTo', page );
				cssResize('#procedures-popup.ce-popup-full-size');
			} );

			this.element.on('tap keydown', '#procedures-filter',function(e){
				if (e.type === 'tap' || ( e.type === 'keydown' && e.which === 13 ) ) { // Enter key
					$('#procedures-popup').popup( 'option', 'positionTo', page ).popup('open');
					if (o.autocompleteList.length > 0) {
						that._redrawAutocompleteList(o.autocompleteList);
					}
					$('#procedures-popup .ui-input-search input').focus();
				}
			});

			$('#procedures-popup').on('tap keydown', 'a[title="close"]', function(e) {
				if (e.type === 'tap' || ( e.type === 'keydown' && e.which === 13 ) ) { // Enter key
					e.preventDefault();
					$('#procedures-popup').popup('close');
				}
			});

			$('#procedures-popup').on('tap keydown', '.procedures-section-autocomplete a.ui-input-clear',function(e){
				if (e.type === 'tap' || (e.type === 'keydown' && e.which === 13) ) {
					e.preventDefault();
					that._setOption("autocompleteList",[]);
					$('#procedures-autocomplete').empty();
				}
			});

			$('#procedures-popup').on('keydown', '.procedures-section-autocomplete input',function(e){
				var key = e.which;
				switch(key){
					case 38: //up arrow
						if ($('#procedures-autocomplete').is(":visible")) {
							e.currentTarget.blur();

							var autocompleteList = $('#procedures-autocomplete li:visible').not('[data-role = "list-divider"]');

							autocompleteList.eq(autocompleteList.length-1).find('a').focus();
						}
						break;
					case 40: //down arrow
						if ($('#procedures-autocomplete').is(":visible")) {
							$('#procedures-autocomplete li:visible').not('[data-role = "list-divider"]').eq(0).find('a').focus();
						}
						break;
				}
			});

			$('#procedures-popup').on('keyup', '.procedures-section-autocomplete input',function(e){
				var key = e.which;
				switch(key){
					case 27: //Escape
						$('#procedures-autocomplete').empty();
						break;
					default:
						if (e.currentTarget.value.length >= 3) {
							that._getNewAutocompleteList();
						} else {
							$('#procedures-autocomplete').empty();
						}
						break;
				}
			});

			$('#procedures-popup').on('keydown', '#procedures-autocomplete li a',function(e){
				var key = e.which;

				switch (e.which){
					case 13: //Enter
					case 32: //Space Bar
						e.preventDefault();
						$(e.currentTarget).closest('li').hide();
						that._selectProcedure(e);
						break;
					case 27: //Escape
						$('#procedures-popup').popup('close');
						e.preventDefault();
						return false;
						break;
					case 38: //up arrow
						that._moveUp(e);
						break;
					case 40: //down arrow
						that._moveDown(e);
						break;
				}
			});

			$('#procedures-popup').on('tap', '#procedures-autocomplete li a',function(e){
				e.preventDefault();
				$(e.currentTarget).closest('li').hide();
				that._selectProcedure(e);
			});

			var proceduresPopupEscapeHandler = function(e){
				if(e.which === 27){
					$('#procedures-popup').popup('close');
					$('#procedures-autocomplete').css("display", "none");
					e.preventDefault();

					$("#procedures-filter").focus();
					return false;
				}
			};

			$("#procedures-popup").on("keyup", function(e){
				return proceduresPopupEscapeHandler(e);
			});

			$("#procedures-popup-popup").on("keyup", function(e){
				return proceduresPopupEscapeHandler(e);
			});

			$("#procedures-popup-screen").on("keyup", function(e){ //may not be a necessary handler, not sure if screen can ever get focus
				return proceduresPopupEscapeHandler(e);
			});

			var selectProcedure = function(e) {
				e.preventDefault();
				$(e.currentTarget).closest('li').toggleClass('ui-btn-active');
				that._toggleButtons();
			};
			this.element.on('tap', '#procedure-list li .procedures-list-item',function(e){
				selectProcedure(e);
			});
			this.element.on('keydown', '#procedure-list li .procedures-list-item',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					selectProcedure(e);
				}
			});

			var setFocusWithinProcedureForm = function() {
				// called after 'Select All', 'Deselect All', or 'Remove' is tapped or Entered
				var selectable = $('#select-all-procedures, #deselect-all-procedures, #remove-procedures').filter(':enabled');
				if (selectable.length > 0) {
					selectable.eq(0).focus();
				} else {
					// set focus to collapsible header Procedures
					$(that.element).find(".ui-collapsible-heading-toggle").eq(4).focus();
				}
			};
			this.element.on('tap', '#select-all-procedures',function(e){
				that._selectAllItems();
				setFocusWithinProcedureForm();
			});
			this.element.on('keydown', '#select-all-procedures',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					that._selectAllItems();
					setFocusWithinProcedureForm();
				}
			});

			this.element.on('tap', '#deselect-all-procedures',function(e){
				that._deselectAllItems();
				setFocusWithinProcedureForm();
			});
			this.element.on('keydown', '#deselect-all-procedures',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					that._deselectAllItems();
					setFocusWithinProcedureForm();
				}
			});

			var removeProcedures = function() {
				var highlightedProcedures = $('#procedure-list > li.ui-btn-active');

				_.each(highlightedProcedures, function(itemToRemove){
					that._setOption('removeSelectedProcedure',{'ien':$(itemToRemove).data('procedure-ien'), 'code':$(itemToRemove).data('cpt-code')});
				});

				that._drawSelectedProcedures(); // calls _validate()
				that._toggleButtons();
			};
			this.element.on('tap', '#remove-procedures',function(e) {
				removeProcedures();
				setFocusWithinProcedureForm();
			});
			this.element.on('keydown', '#remove-procedures',function(e) {
				if (e.which === 13 || e.which === 32){ // Enter or Space Bar
					removeProcedures();
					setFocusWithinProcedureForm();
				}
			});

			var openProcedureModifiers = function(e) {
				e.preventDefault();
				var listItem = $(e.currentTarget).closest('li').find('div.ui-btn-text a'),
					code = listItem.data('cpt-code'),
					ien = listItem.data('procedure-ien'),
					template = that._templates().get(),
					$listContainer = $(template.modifiers),
					$modifiersPopup = $('#procedure-modifiers'),
					$modifiersPopupContent = $modifiersPopup.find('[data-role="content"]'),
					modifierItem = _.template(template.modifierItem),
					modifiers = [],
					currentProcedure = _.find(o.selectedProcedures,function(item){
						if(String(item.ien) === String(ien) && String(item.code) === String(code)){
							return item;
						}
					});

				$modifiersPopup.find('[role="heading"]').text("Modifiers");

				if (currentProcedure.modifiers.length !== 0) {
					modifiers = currentProcedure.modifiers;

					that._setOption('setCurrentProcedure',{'procedureId': ien,'procedureCode': code});

					if (modifiers.length !== 0) {
						_.each(modifiers, function(node){
							$listContainer.append(modifierItem(node));
						});
					} else {
						$modifiersPopup.find('[role="heading"]').text("No Modifiers Found");
					}

					$modifiersPopupContent.empty().prepend($listContainer);
					$modifiersPopup.trigger('create').popup('open');

				} else {

					// TODO: currently modifiers defaults to empty array [],
					// need way to distinguish between no modifiers found and not yet added,
					// else it will run every time when there are no modifiers

					o.parent.progressNotes('publicGet', that.options.modifiers+ "?cpt-code=" + code, function(){
						modifiers = this.modifier;
						if(typeof modifiers === "undefined")
						{
							modifiers = [];
						}
						_.each( modifiers ,function(selectedModifiers){
							selectedModifiers.selected = false;
						});
						var procedure = _.find(o.selectedProcedures, function(procedure) {
							if(ien == procedure.ien && code == procedure.code){
								return procedure;
							}
						});
						_.each(procedure.selectedModifiers , function(item){
							item.selected = true;
							_.find( modifiers ,function(selectedModifiers){
								if(selectedModifiers.ien == item.ien && selectedModifiers.code == item.code) {
									selectedModifiers.selected = true;
									return;
								}
							});
						});

						that._setOption('selectedProcedureModifiers', {'selectedProcedure': currentProcedure, 'modifiers': modifiers});
						that._setOption('setCurrentProcedure',{'procedureId': ien,'procedureCode': code});

						if (modifiers.length !== 0) {
							_.each(modifiers, function(node){
								$listContainer.append(modifierItem(node));
							});
						} else {
							$modifiersPopup.find('[role="heading"]').text("No Modifiers Found");
						}

						$modifiersPopupContent.empty().prepend($listContainer);
						$modifiersPopup.trigger('create').popup('open');
					});
				}

				$modifiersPopupContent.css("max-height", $(window).height() - 100);

				return false;
			};

			this.element.on('tap', '.procedures-modifiers',function(e){
				return openProcedureModifiers(e);
			});
			this.element.on('keydown', '.procedures-modifiers',function(e){
				if (e.which === 13 || e.which === 32){ // Enter or Space Bar
					return openProcedureModifiers(e);
				}
			});
			$(document).on('tap', '#procedure-modifiers button',function(e){
				$('#procedure-modifiers').popup('close');
			});
			$(document).on('keydown', '#procedure-modifiers button',function(e){
				if (e.which === 13 || e.which === 32){ // Enter or Space Bar
					$('#procedure-modifiers').popup('close');
				}
			});
			$(document).on('popupafterclose', '#procedure-modifiers',function(e){
				that._drawSelectedProcedures(true);
			});

			$(document).on('tap click', '#procedure-modifiers .ui-checkbox', function(e){
				var checkbox = $(this).find("input[type='checkbox']"),
					ien = checkbox.data("ien"),
					code = checkbox.data("code");

				that._setOption( 'updateModifier', { 'ien' : ien, 'code' : code } );
			});


			var modifiersPopupEscapeHandler = function(e){
				if(e.which === 27){
					$('#procedure-modifiers').popup('close');
					e.preventDefault();
					return false;
				}
			};

			$("#procedure-modifiers").on("keyup", function(e){
				return modifiersPopupEscapeHandler(e);
			});
			$("#procedure-modifiers-popup").on("keyup", function(e){
				return modifiersPopupEscapeHandler(e);
			});
			$("#procedure-modifiers-screen").on("keyup", function(e){ //may not be a necessary handler, not sure if screen can ever get focus
				return modifiersPopupEscapeHandler(e);
			});
		},

		_move: function(e, firstTry, secondTry) {
			var $closestLi = $(e.currentTarget).closest('li'),
				elementList = $closestLi[firstTry]().not('.ui-screen-hidden');
			if (elementList.length) {
				$(elementList[0]).find('a').focus();
				return;
			}

			elementList = $closestLi[secondTry]().not('.ui-screen-hidden');
			if (elementList.length) {
				$(elementList[(elementList.length -1)]).find('a').focus();
			}
		},
		_moveUp: function(e){
			e.preventDefault();
			this._move(e, 'prevAll', 'nextAll');
		},

		_moveDown: function(e){
			e.preventDefault();
			this._move(e, 'nextAll', 'prevAll');
		},
		_toggleButtons: function(){
			var procedures = $('#procedure-list > li'),
				proceduresLength = procedures.length,
				selectedProceduresLength = procedures.filter('.ui-btn-active').length;
			if (proceduresLength === 0) {
				$('#select-all-procedures').button( "disable" );
				$('#deselect-all-procedures').button( "disable" );
				$('#remove-procedures').button( "disable" );
			} else {
				if (selectedProceduresLength === 0) {
					$('#select-all-procedures').button( "enable" );
					$('#deselect-all-procedures').button( "disable" );
					$('#remove-procedures').button( "disable" );
				} else if (selectedProceduresLength === proceduresLength) {
					$('#select-all-procedures').button( "disable" );
					$('#deselect-all-procedures').button( "enable" );
					$('#remove-procedures').button( "enable" );
				} else {
					$('#select-all-procedures').button( "enable" );
					$('#deselect-all-procedures').button( "enable" );
					$('#remove-procedures').button( "enable" );
				}
			}
		},
		_selectAllItems: function(){
			var selectedItem = $('#procedure-list > li');

			_.each(selectedItem, function(item){
				$(item).addClass('ui-btn-active');
			});
			this._toggleButtons();
		},
		_deselectAllItems: function(){
			var selectedItem = $('#procedure-list > li');

			_.each(selectedItem, function(item){
				$(item).removeClass('ui-btn-active');
			});
			this._toggleButtons();
		},
		_hideAutocompleteList: function(){
			$('#procedures-autocomplete').empty();
		},
		_drawSelectedProcedures: function(persistActive){
			persistActive = persistActive || false;

			var template = this._templates().get(),
				listTemplate = template.proceduresList,
				listItemTemplate = _.template(template.proceduresListItem),
				listItems = this.options.selectedProcedures,
				highlightedProcedures,
				proceduresListContainer = $('#procedures-list-container');
				newContent = "";

			if (persistActive) {
				highlightedProcedures = proceduresListContainer.find("li.ui-btn-active .procedures-list-item");
			}

			proceduresListContainer.empty();

			_.each(listItems, function(item){
				if (typeof item.selectedModifiers === "undefined") {
					item.selectedModifiers = [];
				}
				item.isActive = false;
				if (persistActive && highlightedProcedures.length > 0) {
					var numHighlighted = highlightedProcedures.length,
						i;
					for (i = 0; i < numHighlighted; i++) {
						if (item.code == highlightedProcedures.eq(i).attr('data-cpt-code') && item.ien == highlightedProcedures.eq(i).attr('data-procedure-ien')) {
							item.isActive = true;
							break;
						}
					}
				}
				newContent += listItemTemplate(item);
			});
			newContent = $(listTemplate).append(newContent);
			proceduresListContainer.empty().append($(newContent));
			proceduresListContainer.trigger('create');

			this._validate();
		},
		_selectProcedure: function(e){
			var that = this,
				code = $(e.currentTarget).data('cpt-code'),
				ien = $(e.currentTarget).data('procedure-ien'),
				autocompleteList = this.options.autocompleteList,
				procedure = _.find(autocompleteList, function(item){
					return ( String(item.ien) === String(ien) && String(item.code) === String(code) );
				});

			that._setOption( 'selectedProcedures', { 'selectedProcedure': procedure, 'modifiers': [], 'selectedModifiers': [] } );
			that._drawSelectedProcedures(true);
			that._toggleButtons();
		},
		_getNewAutocompleteList: function(){
			var that = this,
				o = this.options,
				autocompleteText = $('.procedures-section-autocomplete input').val();

			o.parent.progressNotes('publicGet', o.link + "?searchstring=" + autocompleteText, function(){
				if (this.size > 0) {
					that._setOption("autocompleteList", this.encounterCode);
				} else {
					that._setOption("autocompleteList", []);
				}
				that._redrawAutocompleteList(o.autocompleteList);
			}, function() {
				var message = $.parseJSON(this.responseText).message;
				if (message === "Service timed out, please re-try.") {
					message = "Too many results, please narrow your search.";
				}
				that._setOption("autocompleteList", []);
				that._redrawAutocompleteList( o.autocompleteList, message );
			});
		},
		_redrawAutocompleteList: function(listItems, message){
			var template = this._templates().get(),
				list = "",
				listItem = _.template(template.proceduresAutocompleteListItem),
				noListItem = _.template(template.proceduresAutocompleteNoListItem),
				selectedProcedures = this.options.selectedProcedures,
				uniqueAutocompleteList = [];

			if (selectedProcedures.length > 0) {
				_.each(listItems, function(node){
					var procedurePresent = false;
					_.find(selectedProcedures, function(existingObject){
						if (String(node.ien) === String(existingObject.ien) && String(node.code) === String(existingObject.code)){
							procedurePresent = true;
						}
					});
					if (!procedurePresent) {
						uniqueAutocompleteList.push(node);
					}
				});
			} else {
				uniqueAutocompleteList = listItems;
			}

			if (uniqueAutocompleteList.length === 0) {
				list += noListItem({ message : message || "There Were No Results Found Matching Your Search"  });
			} else {
				_.each(uniqueAutocompleteList, function(node){
					list += listItem(node);
				});
			}
			$('#procedures-autocomplete').empty().append(list).listview('refresh').show();

		},
		_templates: function(){
			/*jshint multistr: true */
			templates = {
				main: '<div data-role="collapsible" class="inset-select-list"> \
								<h3>Procedures</h3> \
								<div id="procedures-section" class="progress-note-collapsible procedures-section">\
								</div> \
							</div> ',
				proceduresList: '<ul id="procedure-list" data-role="listview" data-split-icon="grid" data-split-theme="d" data-inset="false" class="split-button-with-input" ></ul> ',
				proceduresListContainer:'<div class="progress-note-collapsible-padding"> \
									<button id="procedures-filter" data-icon="search" data-iconpos="right" aria-haspopup="true">Add Procedure...</button> \
								</div> \
								<div id="procedures-list-container"></div> \
								<div class="progress-note-collapsible-padding button-set-right"> \
									<button id="select-all-procedures" data-inline="true" data-mini="true" data-theme="c" >Select All</button> \
									<button id="deselect-all-procedures" data-inline="true" data-mini="true" data-theme="c">Deselect All</button> \
									<button id="remove-procedures" data-inline="true" data-mini="true" data-theme="c">Remove</button> \
								</div>',
				proceduresPopup: '<div data-role="popup" id="procedures-popup" class="ce-popup-full-size" data-overlay-theme="a" data-shadow="true" data-theme="d"> \
									<a href="#" data-rel="back" data-role="button" data-theme="b" data-icon="delete" data-iconpos="notext" title="close" class="ui-btn-close ui-btn-right ui-btn ui-shadow ui-btn-icon-notext ui-btn-up-b"><span class="ui-btn-inner"><span class="ui-btn-text">Close</span><span class="ui-icon ui-icon-delete ui-icon-shadow">&nbsp;</span></span></a> \
									<div data-role="header" data-theme="b" class="ui-header ui-bar-b"> \
										<h3 role="heading" aria-level="1" class="ui-title">Add Procedures</h3> \
									</div> \
									<div data-role="content" class="procedures-section-autocomplete"> \
										<ul id="procedures-autocomplete" class="autocomplete-list" data-role="listview" data-filter="true" data-filter-placeholder="Enter Procedure..." ></ul> \
									</div> \
								</div>',
				proceduresAutocompleteListItem:'<li data-icon="false"><a data-cpt-code="<%= code %>" data-procedure-ien="<%= ien %>" href="#"><h3><% if(code != ""){ %><%= code %> - <% } %><%= shortDescription %></h3><p><%= description %></p></a></li>',
				proceduresAutocompleteNoListItem:'<li>\
									<%= message %>\
									</li>',
				proceduresListItem:'<li <% if (isActive) { %>class="ui-btn-active"<% } %>>\
										<a class="procedures-list-item" data-cpt-code="<%= code %>" data-procedure-ien="<%= ien %>" href="#"> \
											<h3><%= code %> - <%= shortDescription %></h3><p><%= description %></p> \
											<ul class="modifiers-list"><% for(var i=0; i < selectedModifiers.length; i++){ %><li class="ui-li-desc" data-code="<%= selectedModifiers[i].code %>" data-ien="<%= selectedModifiers[i].ien %>"><%= selectedModifiers[i].name %></li><% } %></ul> \
										</a> \
										<a href="#" class="procedures-modifiers" data-rel="popup" data-position-to="window" data-transition="pop">Add Modifiers</a> \
									</li>',
				modifiersPopup: '<div data-role="popup" id="procedure-modifiers" data-overlay-theme="a" data-shadow="true" data-theme="d"> \
									<a href="#" data-rel="back" data-role="button" data-theme="b" data-icon="delete" data-iconpos="notext" title="close" class="ui-btn-close ui-btn-right ui-btn ui-shadow ui-btn-icon-notext ui-btn-up-b"><span class="ui-btn-inner"><span class="ui-btn-text">Close</span><span class="ui-icon ui-icon-delete ui-icon-shadow">&nbsp;</span></span></a> \
                                    <div data-role="header" data-theme="b" class="ui-header ui-bar-b"> \
                                        <h3 role="heading" aria-level="1" class="ui-title">Modifiers</h3> \
                                    </div> \
									<div data-role="content"></div> \
									<div><button id="modifiers-done-btn" data-mini="true" data-theme="b">Done</button></div> \
								</div>',
				modifiers: '<fieldset data-role="controlgroup" class="group-vertical-input"></fieldset>',
				modifierItem: '<label for="<%= name %>IsProcedureModifier" data-iconpos="right"> \
								<input type="checkbox" id="<%= name %>IsProcedureModifier" name="procedureModifier" data-ien="<%= ien %>" data-code="<%= code %>" <% if (selected) { %> checked="checked" <% } %>  /> \
								<%= name %> \
							</label>'
			};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.diagnosis", {
		// These options will be used as defaults
		options: {
			defaults: {
				autocompleteList: [],
				problemList: [],
				diagnosisList: []
			}
		},
		_setOption: function(key, value){
			var o = this.options;

			switch (key) {
				case "autocompleteList":
					o.autocompleteList = value;
					break;
				case "problemList":
					o.problemList = value;
					break;
				case "diagnosisList":
					o.diagnosisList = value;
					break;
			}
		},
		_removeProblem: function(indicesToRemove) {
			var o = this.options,
				isEqual;

			if ($.isArray(indicesToRemove)) { // indicesToRemove is an array of indices
				o.problemList = _.reject(o.problemList, function(problem, index) {
					return typeof _.find(indicesToRemove, function(removeIndex) {
						isEqual = index === removeIndex;

						if (isEqual) {
							problem.selected = false;
						}

						return isEqual;
					}) !== "undefined" && !problem.fromProblemList;
				});
			} else { // indicesToRemove is a single integer
				var removeAtIndex = indicesToRemove;

				if (removeAtIndex >= 0) {
					if (o.problemList[removeAtIndex].fromProblemList) {
						o.problemList[removeAtIndex].selected = false;
					} else {
						o.problemList.splice(removeAtIndex, 1);
					}
				}
			}
		},
		_removeProblemByCodes: function(problemsToRemove) {
			var o = this.options,
				foundProblem,
				isEqual;

			if ($.isArray(problemsToRemove)) { // problemsToRemove is an array of objects
				o.problemList = _.reject(o.problemList, function(problem) {
					return typeof _.find(problemsToRemove, function(removeProblem) {
						isEqual = problem.ien === removeProblem.ien && problem.code === removeProblem.code;

						if (isEqual) {
							problem.selected = false;
						}
						return isEqual;
					}) !== "undefined" && !problem.fromProblemList;
				});

			} else { // problemsToRemove is a single object
				var removeProblem = problemsToRemove,
					removeAtIndex = -1;

				foundProblem = typeof _.find(o.problemList, function(problem, index) {
					removeAtIndex = index;
					return problem.ien === removeProblem.ien && problem.code === removeProblem.code;
				}) !== "undefined";

				if (foundProblem) {
					if (foundProblem.fromProblemList) {
						o.problemList[removeAtIndex].selected = false;
					} else {
						o.problemList.splice(removeAtIndex, 1);
					}
				}
			}
		},
		_addDiagnosis: function(key, index) { // key either "fromAutocomplete" or "fromProblem"
			var o = this.options,
				selectedDiagnosis,
				foundProblem;

			// deep clone and if diagnosisList.length === 0, then set primaryDiagnosis to true
			if (index >= 0) {
				switch(key){
					case "fromAutocomplete":
						selectedDiagnosis = o.autocompleteList[index];
						break;
					case "fromProblem":
						selectedDiagnosis = o.problemList[index];
						break;
					default: // bad key
						return;
						break;
				}

				// set fromProblemList if match found in problem list
				foundProblem = typeof _.find(o.problemList, function(problem) {
						return problem.ien === selectedDiagnosis.ien && problem.code === selectedDiagnosis.code;
					}) !== "undefined";

				selectedDiagnosis.primaryDiagnosis = (o.diagnosisList.length === 0);

				o.diagnosisList.push($.extend(
					true,
					{
						addToProblemList: false,
						fromProblemList: foundProblem
					},
					selectedDiagnosis
				));
			}
		},
		_removeDiagnosis: function(indicesToRemove) {
			var o = this.options,
				removedPrimary = false;

			if ($.isArray(indicesToRemove)) { // indicesToRemove is an array of indices
				removedPrimary = typeof _.find(indicesToRemove, function(index){
						return o.diagnosisList[index].primaryDiagnosis;
					}) !== "undefined";

				o.diagnosisList = _.reject(o.diagnosisList, function(diagnosis, index) {
					return typeof _.find(indicesToRemove, function(removeIndex) {
						return index === removeIndex;
					}) !== "undefined";
				});
			} else { // indicesToRemove is a single integer
				var removeAtIndex = indicesToRemove;

				removedPrimary = o.diagnosisList[removeAtIndex].primaryDiagnosis;

				if (removeAtIndex >= 0) {
					o.diagnosisList.splice(removeAtIndex, 1);
				}
			}

			if (removedPrimary && o.diagnosisList.length > 0) {
				o.diagnosisList[0].primaryDiagnosis = true;
			}
		},
		_removeDiagnosisByCodes: function(diagnosesToRemove) {
			var o = this.options,
				foundDiagnosis,
				removedPrimary = false;

			if ($.isArray(diagnosesToRemove)) { // diagnosesToRemove is an array of objects
				o.diagnosisList = _.reject(o.diagnosisList, function(problem) {
					var isMatch;
					return typeof _.find(diagnosesToRemove, function(removeProblem) {
						isMatch = problem.ien === removeProblem.ien && problem.code === removeProblem.code;
						if (isMatch) {
							removedPrimary = removedPrimary || problem.primaryDiagnosis;
						}
						return isMatch;
					}) !== "undefined";
				});

			} else { // diagnosesToRemove is a single object
				var removeProblem = diagnosesToRemove,
					removeAtIndex = -1;

				removedPrimary = removeProblem.primaryDiagnosis;

				foundDiagnosis = _.find(o.diagnosisList, function(problem, index) {
					isMatch = problem.ien === removeProblem.ien && problem.code === removeProblem.code;
					if (isMatch) {
						removedPrimary = problem.primaryDiagnosis;
					}
					return isMatch;
				});

				if (typeof foundDiagnosis !== "undefined") {
					o.diagnosisList.splice(removeAtIndex, 1);
				}
			}

			if (removedPrimary && o.diagnosisList.length > 0) {
				o.diagnosisList[0].primaryDiagnosis = true;
			}
		},
		_validate: function() {
			var pass = this.options.diagnosisList.length > 0;

			this.element.trigger(this.widgetEventPrefix, {
				pass: pass
			});
		},
		_create: function(){
			$.extend(this.options, $.extend(true, {}, this.options.defaults));

			var that = this,
				o = this.options,
				section = this.element,
				template = this._templates().get(),
				diagnosisRow = _.template(template.selectedDiagnosisItem),
				domSectionMain = template.main,
				domDiagnosisList = [];

			o.parent.progressNotes('registerWidget', this);

			section.append(domSectionMain);
			$('#diagnosis-section').append(template.diagnosesPopup);
			$('#diagnosis-section').trigger('create');
			$('#diagnoses-popup').popup();


			// load and render problem list
			o.parent.progressNotes('publicGet', o.problemLink, function(){
				var problemList = [],
					isInProblemList;

				problemList = this.encounterDiagnosisICDCode || [];

				// set addToProblemList in problem list based on diagnosis list items
				_.each(problemList, function(problem) {
					isInProblemList = typeof _.find(o.diagnosisList, function(selectedDiagnosis) {
						return problem.ien === selectedDiagnosis.ien && problem.code === selectedDiagnosis.code;
					}) !== "undefined";

					problem.addToProblemList = isInProblemList ? true : problem.addToProblemList;
					problem.selected = isInProblemList ? true : false;
				});

				that._setOption("problemList", problemList);
				that._redrawProblemList();
			}, function() {
				var problemList = [],
					isInProblemList;

				that._setOption("problemList", problemList);
				that._drawProblemListMessage( $.parseJSON(this.responseText).message );
			});

			// load and render diagnosis list;
			// this can be done asynchronously because each diagnosis has the flag fromProblemList
			this._resume();

			_.each(o.diagnosisList, function(diagnosis) {
				domDiagnosisList.push(diagnosisRow(diagnosis));
			});

			section.find('#diagnosis-list').append(domDiagnosisList.join(""));

			// toggle buttons after enhanced by jQuery mobile
			// all disabled by default
			if (o.diagnosisList.length > 0) {
				section.find('#select-all-diagnosis').button('enable');
			}

			// create done by parent widget

			this._delegateEvents();
		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			$('#diagnoses-popup').off('popupbeforeposition');
			$('#diagnoses-popup').off('tap keydown', 'a[title="close"]');
			$('#diagnoses-popup').off('keyup', '#diagnosis-section-autocomplete input');
			$('#diagnoses-popup').off('keyup', '#diagnosis-autocomplete li a');
			$('#diagnoses-popup').off('tap keydown', '#diagnosis-section-autocomplete .ui-input-clear');
			$('#diagnoses-popup').off('focus', '#diagnosis-section-autocomplete input');
			$('#diagnoses-popup').off('tap', '#diagnosis-autocomplete li a');

			$('#diagnoses-popup').popup('destroy');
			$('#diagnoses-popup').remove();
		},
		_resume: function(){
			var diagnosisList = this.options.parent.progressNotes('getDiagnosesInfo');
			this._setOption("diagnosisList", diagnosisList);
		},
		_delegateEvents: function(){
			var that = this,
				section = this.element,
				page = that.options.parent.progressNotes('option', 'page'),
				o = this.options,
				cssResize = function(selector) {
					var $selector = $(selector),
						$page = $(page),
						width = Math.round($page.innerWidth()) - 4,
						height = Math.round($page.innerHeight()) - 14;

					$selector.css({
						'max-width': width + 'px',
						'width': width + 'px',
						'height': height + 'px'
					});
					$(selector + ' [data-role="content"]').css({'height': height - 39 + 'px' });
				};

			$('#diagnoses-popup').on('popupbeforeposition', function( event, ui ) {
				$('#diagnoses-popup').jqmData('positionTo', page);
				cssResize('#diagnoses-popup.ce-popup-full-size');
			});

			this.element.on('tap keydown', '#diagnoses-filter',function(e){
				if (e.type === 'tap' || ( e.type === 'keydown' && e.which === 13 ) ) { // Enter key
					$('#diagnoses-popup').popup( 'option', 'positionTo', page ).popup('open');
					if (o.autocompleteList.length > 0) {
						that._getNewAutocompleteList();
					}
					$('#diagnoses-popup .ui-input-search input').focus();
				}
			});

			$('#diagnoses-popup').on('tap keydown', 'a[title="close"]', function(e) {
				if (e.type === 'tap' || ( e.type === 'keydown' && e.which === 13 ) ) { // Enter key
					e.preventDefault();
					$('#diagnoses-popup').popup('close');
				}
			});

			// autocomplete
			//section.on('keyup', '#diagnosis-section-autocomplete input',function(e){
			$('#diagnoses-popup').on('keydown', '#diagnosis-section-autocomplete input',function(e){
				var key = e.which;
				switch(key){
					case 38: //up arrow
						if($('#diagnosis-autocomplete').is(":visible")){
							e.currentTarget.blur();

							var autocompleteList = $('#diagnosis-autocomplete li:visible').not('[data-role = "list-divider"]');

							autocompleteList.eq(autocompleteList.length-1).find('a').focus();
						}
						break;
					case 40: //down arrow
						if($('#diagnosis-autocomplete').is(":visible")){
							$('#diagnosis-autocomplete li:visible').not('[data-role = "list-divider"]').eq(0).find('a').focus();
						}
						break;
				}
			});

			$('#diagnoses-popup').on('keyup', '#diagnosis-section-autocomplete input',function(e){
				var key = e.which;
				switch(key){
					case 27: //Escape
						e.preventDefault();
						//that._hideAutocompleteList();
						break;
					default:
						if (e.currentTarget.value.length >= 3) {
							that._getNewAutocompleteList();
						} else {
							that._emptyAutocompleteList();
						}
						break;
				}
			});

			//section.on('keyup', '#diagnosis-autocomplete li a',function(e){
			$('#diagnoses-popup').on('keydown', '#diagnosis-autocomplete li a',function(e){
				var key = e.which;
				switch (e.which){
					case 13: //Enter
					case 32: //Space Bar
						e.preventDefault();
						that._selectDiagnosisFromAutocomplete($(e.currentTarget).closest('li'));
						break;
					case 27: //Escape
						e.preventDefault();
						//that._hideAutocompleteList();
						return false;
						break;
					case 38: //up arrow
						that._moveUp(e);
						break;
					case 40: //down arrow
						that._moveDown(e);
						break;
				}
			});

			$('#diagnoses-popup').on('tap keydown', '#diagnosis-section-autocomplete .ui-input-clear',function(e){
				if ( e.type === 'tap' || (e.type === 'keydown' && e.which === 13) ) {
					e.preventDefault();
					that._emptyAutocompleteList();
					$("#diagnosis-section-autocomplete input").val("");
				}
			});

			$('#diagnoses-popup').on('focus', '#diagnosis-section-autocomplete input',function(e){
				var autocompletelist = $('#diagnosis-section-autocomplete ul.autocomplete-list'),
					autocompleteOffset = $('#diagnosis-section-autocomplete input').offset().top + $('#diagnosis-section-autocomplete input').height(),
					autocompleteContainerHeight = $('body').height() - $('#footer').height() - autocompleteOffset - 13;

				autocompletelist.css({"max-height":autocompleteContainerHeight});

				if ( $('#diagnosis-section-autocomplete input').val().length < 2 ) {
					that._hideAutocompleteList();
				} else {
					that._showAutocompleteList();
					if ($('#diagnosis-autocomplete li').length < 0) {
						that._getNewAutocompleteList();
					}
				}
			});

			var diagnosesPopupEscapeHandler = function(e){
				var key = e.which;
				switch (e.which){
					case 27: //Escape
						$('#diagnoses-popup').popup('close');
						e.preventDefault();
						$('#diagnoses-filter').focus();
						return false;
				}
			};

			$('#diagnoses-popup').on('keyup', function(e){
				return diagnosesPopupEscapeHandler(e);
			});
			$('#diagnoses-popup-popup').on('keyup', function(e){
				return diagnosesPopupEscapeHandler(e);
			});
			$('#diagnoses-popup-screen').on('keyup', function(e){
				return diagnosesPopupEscapeHandler(e);
			});

			$('#diagnoses-popup').on('tap', '#diagnosis-autocomplete li a',function(e){
				e.preventDefault();
				that._selectDiagnosisFromAutocomplete($(this).closest("li"));
			});

			// problem list; using the 'change' event will make it trigger for each on redraw
			var toggleAddToDiagnosisList = function(e) {
				var input = $(e.currentTarget).parent().find('input'),
					o = that.options,
					code = input.data('cpt-code') + "",
					ien = input.data('diagnosis-ien') + "",
					index = $('#problem-list .ui-checkbox').index( input.parent() ),
					foundProblem = _.find(o.problemList, function(problem) {
						return problem.code === code && problem.ien === ien;
					});

				foundProblem.selected = !foundProblem.selected;

				if (foundProblem.selected) {
					that._addDiagnosis("fromProblem", index);
				} else {
					that._removeDiagnosisByCodes(foundProblem);
					if (!foundProblem.fromProblemList) {
						that._removeProblem(index);
						that._redrawProblemList();
					}
				}
				that._validate();

				that._redrawSelectedDiagnoses();
			};
			section.on('tap click', '#problem-list .ui-btn',function(e){
				toggleAddToDiagnosisList(e);
			});
			section.on('keydown', '#problem-list input',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					e.preventDefault();
					toggleAddToDiagnosisList(e);
					$(this).prop('checked', !$(this).prop('checked')).checkboxradio('refresh');
					return false;
				}
			});

			// diagnosis list
			section.on('tap click', '#diagnosis-list button', function(e){
				$(e.currentTarget).closest('.ui-btn').toggleClass("ui-btn-active");
				that._toggleButtons();
				return false;
			});
			section.on('keydown', '#diagnosis-list button', function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					$(e.currentTarget).closest('.ui-btn').toggleClass("ui-btn-active");
					that._toggleButtons();
					return false;
				}
			});

			var toggleAddToProblemList = function(e) {
				var index = $("#diagnosis-list .ui-controlgroup").index( $(e.currentTarget).closest(".ui-controlgroup") ),
					input = $(e.currentTarget).closest('.ui-checkbox').find('input'),
					o = that.options,
					diagnosis = o.diagnosisList[index];

				diagnosis.addToProblemList = !diagnosis.addToProblemList;

				that._validate();
			};
			section.on('tap click', '#diagnosis-list .ui-checkbox:not(.ui-disabled) .ui-btn', function(e){
				toggleAddToProblemList(e);
			});
			section.on('keydown', '#diagnosis-list .ui-checkbox input',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					e.preventDefault();
					toggleAddToProblemList(e);
					$(this).prop('checked', !$(this).prop('checked')).checkboxradio('refresh');
					return false;
				}
			});

			var selectPrimaryDiagnosis = function(e) {
				var index = $("#diagnosis-list .ui-controlgroup").index( $(e.currentTarget).closest(".ui-controlgroup") ),
					input = $(e.currentTarget).closest('.ui-radio').find('input'),
					o = that.options;

				if( !(o.diagnosisList[index].primaryDiagnosis) ) {
					_.each(o.diagnosisList, function(diagnosis){
						diagnosis.primaryDiagnosis = false;
					});
					o.diagnosisList[index].primaryDiagnosis = true;

					that._validate();
				}
			};
			section.on('tap click', '#diagnosis-list .ui-radio .ui-btn', function(e){
				selectPrimaryDiagnosis(e);
			});
			// in keyboard navigation, click event on the -input- is triggered
			section.on('click', '#diagnosis-list .ui-radio input', function(e){
				selectPrimaryDiagnosis(e);
			});

			// diagnosis list buttons
			var toggleSelectedDiagnoses = function(select) {
				var diagnosisList = $('#diagnosis-list .ui-controlgroup-controls > .ui-btn');

				_.each(diagnosisList, function(item){
					$(item).toggleClass('ui-btn-active', select);
				});
				that._toggleButtons();
			},
				setFocusWithinDiagnosisForm = function() {
				// called after 'Select All', 'Deselect All', or 'Remove' is tapped or Entered
				var selectable = $('#select-all-diagnosis, #deselect-all-diagnosis, #remove-diagnosis').filter(':enabled');
				if (selectable.length > 0) {
					selectable.eq(0).focus();
				} else {
					// set focus to collapsible header Diagnosis
					$(that.element).find(".ui-collapsible-heading-toggle").eq(3).focus();
				}
			};
			section.on('tap', '#select-all-diagnosis',function(e){
				toggleSelectedDiagnoses(true);
				setFocusWithinDiagnosisForm();
			});
			section.on('keydown', '#select-all-diagnosis',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					toggleSelectedDiagnoses(true);
					setFocusWithinDiagnosisForm();
				}
			});

			section.on('tap', '#deselect-all-diagnosis',function(e){
				toggleSelectedDiagnoses(false);
				setFocusWithinDiagnosisForm();
			});
			section.on('keydown', '#deselect-all-diagnosis',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					toggleSelectedDiagnoses(false);
					setFocusWithinDiagnosisForm();
				}
			});

			var removeSelectedDiagnoses = function() {
				var highlightedRows = $('#diagnosis-list .ui-controlgroup-controls > .ui-btn.ui-btn-active'),
					o = that.options,
					problemsToRemove = [],
					diagnosisIndicesToRemove = [],
					index,
					diagnosis;

				_.each(highlightedRows, function(dom) {
					index = $("#diagnosis-list .ui-controlgroup").index( $(dom).closest(".ui-controlgroup") );
					diagnosis = o.diagnosisList[index];
					if (diagnosis.addToProblemList || diagnosis.fromProblemList) {
						problemsToRemove.push(diagnosis);
					}
					diagnosisIndicesToRemove.push(index);
				});

				that._removeProblemByCodes(problemsToRemove);
				that._removeDiagnosis(diagnosisIndicesToRemove);
				that._validate();

				if (problemsToRemove.length > 0) {
					that._redrawProblemList();
				}
				that._redrawSelectedDiagnoses();
				that._toggleButtons();
			};
			section.on('tap', '#remove-diagnosis',function(e){
				removeSelectedDiagnoses();
				setFocusWithinDiagnosisForm();
			});
			section.on('keydown', '#remove-diagnosis',function(e){
				if (e.which === 13 || e.which === 32) { // Enter or Space Bar
					removeSelectedDiagnoses();
					setFocusWithinDiagnosisForm();
				}
			});

		},
		_selectDiagnosisFromAutocomplete: function(element){
			var o = this.options,
				index = element.closest("li").index(),
				selectedDiagnosis = o.autocompleteList[index];

			this._addDiagnosis("fromAutocomplete", index);

			element.addClass("ui-screen-hidden"); // hide in list
			this._redrawSelectedDiagnoses();

			// set addToProblemList in problem list if matches
			foundProblem = _.find(o.problemList, function(problem) {
					return problem.ien === selectedDiagnosis.ien && problem.code === selectedDiagnosis.code;
				});

			if (typeof foundProblem !== "undefined") {
				foundProblem.addToProblemList = true;
				this._redrawProblemList();
			}

			this._validate();
		},
		_drawProblemListMessage: function(message){
			var template = this._templates().get(),
				problemList = template.problemListHeader + _.template(template.problemListNoItems, {description: message});

			$('#problem-list').empty().append(problemList).trigger('create');
		},
		_redrawProblemList: function(){
			var o = this.options,
				problemList = o.problemList,
				template = this._templates().get(),
				problemMessage = _.template(template.problemListNoItems),
				problemItem = _.template(template.problemListItem),
				domProblemList = [];

				if (problemList.length > 0) {
					_.each(problemList, function (diagnosis) {
						domProblemList.push(problemItem(diagnosis));
					});
				} else {
					domProblemList.push(problemMessage({"description" : "There Were No Existing Problems Found"}));
				}

			$('#problem-list').empty().append(domProblemList.join("")).trigger('create');
		},
		_redrawSelectedDiagnoses: function(){
			var diagnosisList = this.options.diagnosisList,
				header = $('#diagnosis-list .ui-li-divider'),
				template = this._templates().get(),
				listItem = _.template(template.selectedDiagnosisItem),
				domList = [];

			_.each(diagnosisList, function(diagnosis){
				domList.push(listItem(diagnosis));
			});

			$('#diagnosis-list').empty().append(header).append(domList.join("")).trigger('create');
			this._toggleButtons();
		},
		_toggleButtons: function(){
			var diagnoses = $('#diagnosis-list .ui-controlgroup-controls > .ui-btn'),
				diagnosesLength = diagnoses.length,
				highlightedDiagnosesLength = diagnoses.filter('.ui-btn-active').length;
			if (diagnosesLength === 0) {
				$('#select-all-diagnosis').button( "disable" );
				$('#deselect-all-diagnosis').button( "disable" );
				$('#remove-diagnosis').button( "disable" );
			} else {
				if (highlightedDiagnosesLength === 0) {
					$('#select-all-diagnosis').button( "enable" );
					$('#deselect-all-diagnosis').button( "disable" );
					$('#remove-diagnosis').button( "disable" );
				} else if (highlightedDiagnosesLength === diagnosesLength) {
					$('#select-all-diagnosis').button( "disable" );
					$('#deselect-all-diagnosis').button( "enable" );
					$('#remove-diagnosis').button( "enable" );
				} else {
					$('#select-all-diagnosis').button( "enable" );
					$('#deselect-all-diagnosis').button( "enable" );
					$('#remove-diagnosis').button( "enable" );
				}
			}
		},
		_getNewAutocompleteList: function(){
			var that = this,
				o = this.options,
				autocompleteText = $('#diagnosis-section-autocomplete input').val();

			o.parent.progressNotes('publicGet', o.link + "?searchstring=" + autocompleteText, function(){
				var selectedDiagnoses = $.extend(true, [], that.options.diagnosisList),
					fullList = this.encounterCode,
					autocompleteList = _.reject(fullList, function(autocompleteDiagnosis) {
						return typeof _.find(selectedDiagnoses, function(selectedDiagnosis) {
							return autocompleteDiagnosis.ien === selectedDiagnosis.ien && autocompleteDiagnosis.code === selectedDiagnosis.code;
						}) !== "undefined";
					});

				that._setOption("autocompleteList", autocompleteList);
				that._redrawAutocompleteList();

			}, function() {
				var message = $.parseJSON(this.responseText).message;

				if (message === "Service timed out, please re-try.") {
					message = "Too many results, please narrow your search.";
				}

				that._setOption("autocompleteList", []);
				that._redrawAutocompleteList( message );
			});
		},
		_redrawAutocompleteList: function(message){
			var autocompleteList = this.options.autocompleteList,
				template = this._templates().get(),
				listItem = _.template(template.diagnosisAutocompleteListItem),
				noListItem = _.template(template.diagnosisAutocompleteListNoItem),
				domList = [];
			if(typeof autocompleteList === "undefined" || autocompleteList.length === 0) {
				domList.push(noListItem({ description: message || "There Were No Results Found Matching Your Search" }));
			} else {
				_.each(autocompleteList, function(node, i){
					domList.push(listItem(node));
				});
				if(autocompleteList.length >= 50){
					domList.push(noListItem({ description: "Please Enter More Text To Refine Your Search" }));
				}
			}

			$('#diagnosis-autocomplete').empty().append(domList.join("")).listview('refresh').show();
		},
		_emptyAutocompleteList: function(){
			$("#diagnosis-autocomplete").empty();
		},
		_showAutocompleteList: function(){
			$("#diagnosis-autocomplete").removeClass("ui-screen-hidden");
		},
		_hideAutocompleteList: function(){
			$("#diagnosis-autocomplete").addClass("ui-screen-hidden");
		},
		_move: function(e, firstTry, secondTry) {
			var $closestLi = $(e.currentTarget).closest('li'),
				elementList = $closestLi[firstTry]().not('.ui-screen-hidden');
			if (elementList.length) {
				$(elementList[0]).find('a').focus();
				return;
			}

			elementList = $closestLi[secondTry]().not('.ui-screen-hidden');
			if (elementList.length) {
				$(elementList[(elementList.length -1)]).find('a').focus();
			}
		},
		_moveUp: function(e){
			e.preventDefault();
			this._move(e, 'prevAll', 'nextAll');
		},
		_moveDown: function(e){
			e.preventDefault();
			this._move(e, 'nextAll', 'prevAll');
		},
		_templates: function(){
			/*jshint multistr: true */
			var templates = {
				main: '<div data-role="collapsible"  class="inset-select-list"> \
								<h3>Diagnosis</h3> \
								<div id="diagnosis-section" class="diagnosis-section progress-note-collapsible">\
									<div class="progress-note-collapsible-padding"> \
										<button id="diagnoses-filter" data-icon="search" data-iconpos="right" aria-haspopup="true">Add Diagnosis...</button> \
									</div> \
									<fieldset id="problem-list" data-role="controlgroup" class="group-vertical-input" data-iconpos="right"> \
										<div role="heading" class="ui-li ui-li-divider ui-bar-d">Problem List</div> \
										<div class="ui-loading"><h3>Loading</h3><span class="ui-sending"></span></div> \
									</fieldset> \
									<fieldset id="diagnosis-list"> \
										<div role="heading" class="ui-li ui-li-divider ui-bar-d">Selected Diagnosis <span>Add to P/L</span> <span>Primary</span></li> \
									</fieldset> \
									<div class="button-set-right progress-note-collapsible-padding"> \
										<button id="select-all-diagnosis" disabled="disabled" data-inline="true" data-mini="true" data-theme="c" data-disabled="disabled">Select All</button> \
										<button id="deselect-all-diagnosis" disabled="disabled" data-inline="true" data-mini="true" data-theme="c" data-disabled="disabled">Deselect All</button> \
										<button id="remove-diagnosis" disabled="disabled" data-inline="true" data-mini="true" data-theme="c" data-disabled="disabled">Remove</button></div> \
									</div>\
								</div> \
							</div> ',
				diagnosesPopup: '<div data-role="popup" id="diagnoses-popup" class="ce-popup-full-size" data-overlay-theme="a" data-shadow="true" data-theme="d"> \
									<a href="#" data-rel="back" data-role="button" data-theme="b" data-icon="delete" data-iconpos="notext" title="close" class="ui-btn-close ui-btn-right ui-btn ui-shadow ui-btn-icon-notext ui-btn-up-b"><span class="ui-btn-inner"><span class="ui-btn-text">Close</span><span class="ui-icon ui-icon-delete ui-icon-shadow">&nbsp;</span></span></a> \
									<div data-role="header" data-theme="b" class="ui-header ui-bar-b"> \
										<h3 role="heading" aria-level="1" class="ui-title">Add Diagnoses</h3> \
									</div> \
									<div data-role="content" id="diagnosis-section-autocomplete" class="diagnosis-section-autocomplete"> \
										<ul id="diagnosis-autocomplete" class="autocomplete-list" data-role="listview" data-filter="true" data-icon="false" data-filter-placeholder="Other diagnosis..." ></ul> \
									</div> \
								</div>',
				diagnosisAutocompleteListItem:'<li><a data-cpt-code="<%= code %>" data-diagnosis-ien="<%= ien %>" href="#"> <h3><% if(code !== ""){ %><span class="diagnosis-code"><%= code %></span> - <% } %><%= shortDescription %></h3><p><%= description %></p></a></li>',
				diagnosisAutocompleteListNoItem:'<li data-role="list-divider"><%= description %></li>',
				problemListHeader: '<div role="heading" class="ui-li ui-li-divider ui-bar-d ui-li-has-count">Problem List</div>',
				problemListItem: '<label for="<%= code %>_<%= ien %>"><h3 class="ui-li-heading"><span class="diagnosis-code"><%= code %></span> - <%= shortDescription %></h3><p class="ui-li-desc"><%= description %></p></label> \
											<input data-cpt-code="<%= code %>" data-diagnosis-ien="<%= ien %>" id="<%= code %>_<%= ien %>" type="checkbox" <% if(selected){ %> checked="checked" <% } %> name="isSelectedProblem" data-inset="true"> ',
				problemListNoItems:'<div class="ui-bar-d no-items"><h4><%= description %></h4></div>',
				selectedDiagnosisItem: '<div data-role="controlgroup" data-theme="b"> \
											<button data-theme="d" data-cpt-code="<%= code %>" data-diagnosis-ien="<%= ien %>"> \
												<h3 class="ui-li-heading"><span class="diagnosis-code"><%= code %></span> - <%= shortDescription %></h3><p class="ui-li-desc"><%= description %></p> \
											</button> \
											<label for="add-<%= code %>-<%= ien %>" class="add-to-pl-label add-<%= code.replace(".", "-") %>-<%= ien %> table-input"></label> \
											<input id="add-<%= code %>-<%= ien %>" <% if (fromProblemList){ %> data-disabled="disabled" disabled="disabled" <% } else if (addToProblemList){ %> checked="checked" <% } %> type="checkbox" name="inProblemList" data-inset="true" data-iconpos="notext" />\
											<label for="primary-<%= code %>-<%= ien %>" class="primary-<%= code.replace(".", "-") %>-<%= ien %> table-input"></label> \
											<input id="primary-<%= code %>-<%= ien %>" <% if(primaryDiagnosis){ %> checked="checked" <% } %> type="radio" name="isPrimary" data-inset="true" data-iconpos="notext" />\
										</div>'
			};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});

	$.widget("mobile.sign", {
		// These options will be used as defaults
		options: {
//			clinicalEvent: {
//				providers:[]
//			}
		},
		init: function(){
			this._preview();

			//populate providers list with user content here if it was not filled in

		},
		_create: function(){
			var section = this.element,
				template = this._templates().get();

			this.options.parentElement.progressNotes('registerWidget', this);

			section.html(template.main).trigger('create');
			this._delegateEvents();
			//create method to refresh content based on new object
		},
		destroy: function() {
			this._destroyChildWidgets();
			delete this.options;
			this._super();
		},
		_destroyChildWidgets: function() {
			var $document = $(document);

			$document.off('tap', '#submit-btn');
			$document.off('tap', '#submit-cancel-btn');
			$document.off('popupafteropen', '#signPopup');
			$document.off('popupafterclose', '#signPopup');
			$document.off('keyup', '#progressNotes-pin');

			$('#signPopup').popup('destroy');
			$('#signPopup').remove();
		},
		_preview: function(){
			var o = this.options,
				selectedVisitType,
				parentSelectedVisitType, parentSelectedVisitSection,
				section = $(this.element).find(":jqmData(role='content')"),
				template = this._templates().get(),
				previewTemplate = _.template(template.preview),
				previewEncounterTemplate = _.template(template.previewEncounter);

			o.clinicalEvent = o.parentElement.progressNotes('option', 'clinicalEvent');
			section.empty().append(previewTemplate(o.clinicalEvent));
			if (o.clinicalEvent.encounterEdited) {
				// create object selectedVisitType, as save currently saves all visitTypes to resume with
				// NOTE: previewEncounterTemplate has also been altered to use this object
				if (typeof o.clinicalEvent.encounter.visitTypes != "undefined" && o.clinicalEvent.encounter.visitTypes.length > 0) {
					// set type
					parentSelectedVisitType = _.find(o.clinicalEvent.encounter.visitTypes, function(visitType) {
						return visitType.selected;
					});
					selectedVisitType = {
						name: parentSelectedVisitType.name,
						section: {}
					};
					// set section
					parentSelectedVisitSection = _.find(parentSelectedVisitType.sections, function(section) {
						return section.selected;
					});
					if (typeof parentSelectedVisitSection !== "undefined") {
						selectedVisitType.section = {
							code: parentSelectedVisitSection.code,
							description: parentSelectedVisitSection.description,
							shortDescription: parentSelectedVisitSection.shortDescription,
							modifiers: []
						};
					// set modifiers
						selectedVisitType.section.modifiers = _.filter(parentSelectedVisitSection.modifiers, function(modifier) {
							return modifier.selected;
						});
						if (selectedVisitType.section.modifiers.length === 0) {
							delete selectedVisitType.section.modifiers;
						}
					}
				}

				section.append(previewEncounterTemplate($.extend( { selectedVisitType: selectedVisitType }, o.clinicalEvent )));
			}
			section.trigger('create');
		},
		_setOption: function(key, value){
			var that = this;
			switch(key){
				case '':

				break;
			}
		},
		_validate: function(){
			if ($('#progressNotes-pin').val()) {
				$('#submit-btn').button('enable');
			} else {
				$('#submit-btn').button('disable');
			}

		},
		_delegateEvents: function(){
			var o = this.options,
				that = this,
				template = this._templates().get(),
				$document = $(document);

			this.element.on('tap', '#sign-cancel-btn', function(){
				o.parentElement.progressNotes('close');
			});
			this.element.on('keydown', '#sign-cancel-btn', function(e){
				if(e.which === 13){
					o.parentElement.progressNotes('close');
				}
			});
			this.element.on('tap', '#sign-btn', function(){
				$('#signPopup').popup('open');
			});
			this.element.on('keydown', '#sign-btn', function(e){
				if(e.which === 13){
					$('#signPopup').popup('open');
				}
			});

			$document.on('tap', '#submit-btn', function(e){
				that._signNote();
			});
			$document.on('tap', '#submit-cancel-btn', function(e){
				$('#signPopup').popup('close');
				$('#signPopup').find('input').val('');
			});

			$document.on('popupafteropen', '#signPopup',function(e){
				$('#progressNotes-pin').focus();
			});
			$document.on('popupafterclose', '#signPopup',function(e){
				$('#signPopup').find('.error-message').empty();
			});

			var signPopupEscapeHandler = function(e){
				if(e.which === 27){
					$('#signPopup').popup('close');
					$('#sign-btn').focus();
					e.preventDefault();
					return false;
				}
			};

			$("#signPopup").on('keyup',function(e){
				return signPopupEscapeHandler(e);
			});
			$("#signPopup-screen").on('keyup',function(e){
				return signPopupEscapeHandler(e);
			});
			$("#signPopup-popup").on('keyup',function(e){
				return signPopupEscapeHandler(e);
			});

			$document.on('keydown', '#progressNotes-pin', function(e){
				that._validate();

				if (e.which === 13) { // Enter
					that._signNote();
				}
			});

			$document.on('keydown', '#submit-btn', function(e){
				if(e.which === 13){
					that._signNote();
				}
			});
			$document.on('keydown', '#submit-cancel-btn', function(e){
				if(e.which === 13){
					$('#signPopup').popup('close');
					$('#signPopup').find('input').val('');
				}
			});
		},
		_signNote: function(){
			var o = this.options,
				self = this,
				$pin = $('#progressNotes-pin'),
				clinicalEventWrapper = {};
			clinicalEventWrapper.clinicalEvent = o.clinicalEvent;
			clinicalEventWrapper.electronicSignature = $pin.val();
			$('#submit-btn').button('disable');
			$('#submit-cancel-btn').button('disable');

			o.parentElement.progressNotes('save', clinicalEventWrapper, o.links.sign.href, 'POST', function(){
				$('#signPopup').popup('close');
				o.parentElement.progressNotes('destroy');

				$pin.val('');
				$('#submit-btn').button('enable');
				$('#submit-cancel-btn').button('enable');
			}, function() {
				if (this.getResponseHeader("content-type").indexOf("json") > -1) {
					var respMsg = $.parseJSON(this.responseText).message;
					if(respMsg == "Invalid credentials. Please re-try."){ //change this on the backend to be a standard error message or code
						$('#signPopup').find('.error-message').empty().append(_.template(self._templates().get().sigError));
					}
					else{
						$('#signPopup').find('.error-message').empty().append($.parseJSON(this.responseText).message);
					}
				} else {
					$('#signPopup').find('.error-message').empty();
					// alert goes up
				}
				$pin.val('');
				$('#submit-btn').button('disable');
				$('#submit-cancel-btn').button('enable');
			});
		},
		_templates: function(){
			/*jshint multistr: true */
			var o = this.options,
			templates = {
				main: '<div> \
					<div data-role="content"></div> \
					<div class="ui-grid-a"> \
							<div class="ui-block-a"> \
								<button id="sign-cancel-btn" data-theme="d" data-mini="true" data-theme="b">Cancel</button> \
							</div> \
							<div class="ui-block-b"> \
								<button id="sign-btn" data-mini="true" data-theme="b">Sign</button></div> \
						</div> \
					</div> \
					<div data-role="popup" id="signPopup" data-dismissible="false" data-overlay-theme="a" data-theme="a" class="ui-content"> \
						<div> \
							<h3>Please sign note</h3> \
							<span class="error-message"></span> \
							<label for="progressNotes-pin" class="ui-hidden-accessible">eSig</label> \
							<input type="password" name="pass" id="progressNotes-pin" value="" title="eSignature" placeholder="eSignature" data-theme="a"> \
							<button data-theme="b" data-icon="delete" id="submit-cancel-btn" data-mini="true">Cancel</button> \
							<button disabled data-theme="b" data-icon="check" id="submit-btn" data-mini="true">Submit</button> \
						</div> \
					</div>',
					/* <% if (note.title.isConsult && note.consult.title !== "") { %> \
						<ul data-role="listview" data-inset="true"> \
							<li data-role="list-divider">Consult</li> \
							<li> \
								<h3><%= note.consult.title %></h3> \
							</li> \
						</ul> \'
					<% } %>, */
				preview: '<h3><%= _.escape(note.title.name) %></h3> \
					<p><%= note.body %></p> \
					<ul data-role="listview" data-inset="true"> \
						<li data-role="list-divider">Clinic Event</li> \
						<li> \
							<h3><%= encounter.locationTitle %></h3> \
							<p><%= encounter.appointmentType %></p> \
							<span class="ui-li-aside ui-li-desc"><%= _.formatDate(encounter.timestamp)%> <%= _.formatTime(encounter.timestamp) %></span> \
						</li> \
					</ul>',
				previewEncounter: '<% if (typeof selectedVisitType !== "undefined") { %> \
						<ul data-role="listview" data-inset="true"> \
							<li data-role="list-divider">Visit Type</li> \
							<li> \
								<span class=fieldname>Type</span> \
								<span class=fieldvalue><%= selectedVisitType.name %></span> \
							</li> \
							<% if (typeof selectedVisitType.section !== "undefined" && selectedVisitType.section.code !== "") { %> \
							<li> \
								<span class=fieldname>Section</span> \
								<span class=fieldvalue><%= selectedVisitType.section.description %></span> \
							</li> \
							<% var modifiers = selectedVisitType.section.modifiers; if (typeof modifiers !== "undefined" && modifiers.length > 0) { %> \
								<li> \
									<span class=fieldname>Modifiers</span> \
									<span class=fieldvalue> \
										<% _.each(modifiers, function(modifier) { %> \
											<%= modifier.name %><br /> \
										<% }); %> \
									</span> \
								</li> \
							<% } %> \
							<% } %> \
						</ul> \
					<% } %> \
					<ul data-role="listview" data-inset="true"> \
						<li data-role="list-divider">Providers</li> \
						<% var providers = encounter.providers; _.each(providers, function(providerItem) { %> \
							<% if (providerItem.selected) { %> \
								<li><h3><%= providerItem.facilityProvider.providerName %></h3> \
									<% if (providerItem.primary) { %><span class="ui-li-aside ui-li-desc">Primary</span><% } %> \
								</li> \
							<% } %> \
						<% }); %> \
					</ul> \
					<ul data-role="listview" data-inset="true"> \
						<li data-role="list-divider">Related To</li> \
						<% var relatedTos = encounter.visitRelatedTos; _.each(relatedTos, function(relatedItem){ %> \
							<li> \
								<h3><%= relatedItem.title %></h3> \
								<span class="ui-li-aside ui-li-desc"><% switch (relatedItem.checked) { case true: %>Yes<% break; case false: %>No<% break; default: %>N/A<% ; } %></span> \
							</li> \
						<% }); %> \
					</ul> \
					<ul data-role="listview" data-inset="true"> \
						<li data-role="list-divider">Diagnosis</li> \
						<% var diagnosisList = encounter.diagnosisCodes; _.each(diagnosisList, function(diagnosis){ %> \
							<li> \
								<h3><%= diagnosis.code %> - <%= diagnosis.shortDescription %></h3> \
								<p><%= diagnosis.description %></p> \
								<% if (diagnosis.primaryDiagnosis) { %><span class="ui-li-aside ui-li-desc">Primary</span><% } %> \
							</li> \
						<% }); %> \
					</ul> \
					<ul data-role="listview" data-inset="true"> \
						<li data-role="list-divider">Procedures</li> \
						<% var procedures = encounter.procedureCodes, modifiers; _.each(procedures, function(procedure){ %> \
							<li> \
								<h3><%= procedure.code %> - <%= procedure.shortDescription %></h3> \
								<p class="ui-li-desc"><%= procedure.description %></p> \
								<% modifiers = procedure.modifiers; if (typeof modifiers !== "undefined" && modifiers.length > 0) { %> \
									<div> \
										<ul class="modifiers-list"> \
											<% _.each(modifiers, function(modifier) { %> \
											<li class="ui-li-desc"><%= modifier.name %></li> \
											<% }); %> \
										</ul> \
									</div> \
								<% } %> \
							</li> \
						<% }); %> \
					</ul>',
				sigError: '<span class="error-message">eSignature is incorrect. Please re-enter.</span>'
			};
			return {
				get: function(){
					return templates;
				}
			};
		}
	});
}(jQuery) );
